/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.cache;

import com.google.common.base.Ticker;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.TimeUnit;
import org.cloudfoundry.identity.uaa.cache.UrlContentCache;
import org.cloudfoundry.identity.uaa.util.TimeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

public class ExpiringUrlCache
implements UrlContentCache {
    private static final Logger logger = LoggerFactory.getLogger(ExpiringUrlCache.class);
    private final Duration cacheExpiration;
    private final TimeService timeService;
    private final Cache<String, CacheEntry> cache;

    public ExpiringUrlCache(Duration cacheExpiration, TimeService timeService, int maxEntries) {
        this.cacheExpiration = cacheExpiration;
        this.timeService = timeService;
        this.cache = CacheBuilder.newBuilder().expireAfterWrite(this.cacheExpiration.toMillis(), TimeUnit.MILLISECONDS).maximumSize((long)maxEntries).ticker(Ticker.systemTicker()).build();
    }

    @Override
    public byte[] getUrlContent(String uri, RestTemplate template) {
        try {
            byte[] metadata;
            URI netUri = new URI(uri);
            CacheEntry entry = (CacheEntry)this.cache.getIfPresent((Object)uri);
            byte[] byArray = metadata = entry != null ? entry.data : null;
            if (metadata == null || this.isEntryExpired(entry)) {
                logger.debug("Fetching metadata for " + uri);
                metadata = (byte[])template.getForObject(netUri, byte[].class);
                Instant now = Instant.ofEpochMilli(this.timeService.getCurrentTimeMillis());
                this.cache.put((Object)uri, (Object)new CacheEntry(now, metadata));
            }
            return metadata;
        }
        catch (RestClientException x) {
            logger.warn("Unable to fetch metadata for " + uri, (Throwable)x);
            throw x;
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private boolean isEntryExpired(CacheEntry entry) {
        Instant now = Instant.ofEpochMilli(this.timeService.getCurrentTimeMillis());
        return Duration.between(entry.timeEntered, now).compareTo(this.cacheExpiration) > 0;
    }

    @Override
    public void clear() {
        this.cache.invalidateAll();
    }

    @Override
    public long size() {
        return this.cache.size();
    }

    static class CacheEntry {
        final Instant timeEntered;
        final byte[] data;

        CacheEntry(Instant timeEntered, byte[] data) {
            this.timeEntered = timeEntered;
            this.data = data;
        }
    }
}

