/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.authentication.manager;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;

public class UsernamePasswordExtractingAuthenticationManager
implements AuthenticationManager {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final AuthenticationManager delegate;

    public UsernamePasswordExtractingAuthenticationManager(AuthenticationManager delegate) {
        this.delegate = delegate;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        if (authentication == null) {
            return authentication;
        }
        UsernamePasswordAuthenticationToken output = null;
        if (authentication instanceof UsernamePasswordAuthenticationToken) {
            output = (UsernamePasswordAuthenticationToken)authentication;
        } else {
            output = new UsernamePasswordAuthenticationToken((Object)authentication, authentication.getCredentials(), authentication.getAuthorities());
            output.setAuthenticated(authentication.isAuthenticated());
            output.setDetails(authentication.getDetails());
        }
        return this.delegate.authenticate((Authentication)output);
    }
}

