/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.authentication.manager;

import org.cloudfoundry.identity.uaa.authentication.manager.LockoutPolicyRetriever;
import org.cloudfoundry.identity.uaa.provider.IdentityProvider;
import org.cloudfoundry.identity.uaa.provider.IdentityProviderProvisioning;
import org.cloudfoundry.identity.uaa.provider.LockoutPolicy;
import org.cloudfoundry.identity.uaa.provider.UaaIdentityProviderDefinition;
import org.cloudfoundry.identity.uaa.util.ObjectUtils;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;

public class UserLockoutPolicyRetriever
implements LockoutPolicyRetriever {
    private final IdentityProviderProvisioning providerProvisioning;
    private LockoutPolicy defaultLockoutPolicy;

    public UserLockoutPolicyRetriever(IdentityProviderProvisioning providerProvisioning) {
        this.providerProvisioning = providerProvisioning;
    }

    @Override
    public LockoutPolicy getLockoutPolicy() {
        IdentityProvider idp = this.providerProvisioning.retrieveByOrigin("uaa", IdentityZoneHolder.get().getId());
        UaaIdentityProviderDefinition idpDefinition = (UaaIdentityProviderDefinition)ObjectUtils.castInstance((Object)idp.getConfig(), UaaIdentityProviderDefinition.class);
        if (idpDefinition != null && idpDefinition.getLockoutPolicy() != null) {
            return idpDefinition.getLockoutPolicy();
        }
        return this.defaultLockoutPolicy;
    }

    @Override
    public LockoutPolicy getDefaultLockoutPolicy() {
        return this.defaultLockoutPolicy;
    }

    @Override
    public void setDefaultLockoutPolicy(LockoutPolicy defaultLockoutPolicy) {
        this.defaultLockoutPolicy = defaultLockoutPolicy;
    }
}

