/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.authentication.manager;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.cloudfoundry.identity.uaa.authentication.ProviderConfigurationException;
import org.cloudfoundry.identity.uaa.authentication.UaaAuthenticationDetails;
import org.cloudfoundry.identity.uaa.authentication.UaaLoginHint;
import org.cloudfoundry.identity.uaa.authentication.manager.DynamicZoneAwareAuthenticationManager;
import org.cloudfoundry.identity.uaa.impl.config.RestTemplateConfig;
import org.cloudfoundry.identity.uaa.provider.IdentityProvider;
import org.cloudfoundry.identity.uaa.provider.IdentityProviderProvisioning;
import org.cloudfoundry.identity.uaa.provider.OIDCIdentityProviderDefinition;
import org.cloudfoundry.identity.uaa.provider.oauth.XOAuthAuthenticationManager;
import org.cloudfoundry.identity.uaa.provider.oauth.XOAuthCodeToken;
import org.cloudfoundry.identity.uaa.provider.oauth.XOAuthProviderConfigurator;
import org.cloudfoundry.identity.uaa.zone.ClientServicesExtension;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.util.Base64Utils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;

public class PasswordGrantAuthenticationManager
implements AuthenticationManager {
    private DynamicZoneAwareAuthenticationManager zoneAwareAuthzAuthenticationManager;
    private IdentityProviderProvisioning identityProviderProvisioning;
    private RestTemplateConfig restTemplateConfig;
    private XOAuthAuthenticationManager xoAuthAuthenticationManager;
    private ClientServicesExtension clientDetailsService;
    private XOAuthProviderConfigurator xoauthProviderProvisioning;

    public PasswordGrantAuthenticationManager(DynamicZoneAwareAuthenticationManager zoneAwareAuthzAuthenticationManager, IdentityProviderProvisioning identityProviderProvisioning, RestTemplateConfig restTemplateConfig, XOAuthAuthenticationManager xoAuthAuthenticationManager, ClientServicesExtension clientDetailsService, XOAuthProviderConfigurator xoauthProviderProvisioning) {
        this.zoneAwareAuthzAuthenticationManager = zoneAwareAuthzAuthenticationManager;
        this.identityProviderProvisioning = identityProviderProvisioning;
        this.restTemplateConfig = restTemplateConfig;
        this.xoAuthAuthenticationManager = xoAuthAuthenticationManager;
        this.clientDetailsService = clientDetailsService;
        this.xoauthProviderProvisioning = xoauthProviderProvisioning;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        UaaLoginHint loginHintToUse;
        UaaLoginHint uaaLoginHint = this.zoneAwareAuthzAuthenticationManager.extractLoginHint(authentication);
        List<String> allowedProviders = this.getAllowedProviders();
        String defaultProvider = IdentityZoneHolder.get().getConfig().getDefaultIdentityProvider();
        List<String> identityProviders = this.identityProviderProvisioning.retrieveActive(IdentityZoneHolder.get().getId()).stream().filter(this::providerSupportsPasswordGrant).map(IdentityProvider::getOriginKey).collect(Collectors.toList());
        List<String> possibleProviders = allowedProviders == null ? identityProviders : allowedProviders.stream().filter(identityProviders::contains).collect(Collectors.toList());
        if (uaaLoginHint == null) {
            loginHintToUse = defaultProvider != null && possibleProviders.contains(defaultProvider) ? new UaaLoginHint(defaultProvider) : this.getUaaLoginHintForChainedAuth(possibleProviders);
        } else if (possibleProviders.contains(uaaLoginHint.getOrigin())) {
            loginHintToUse = uaaLoginHint;
        } else {
            if (allowedProviders == null || allowedProviders.contains(uaaLoginHint.getOrigin())) {
                throw new ProviderConfigurationException("The origin provided in the login_hint does not match an active Identity Provider, that supports password grant.");
            }
            throw new ProviderConfigurationException("Client is not authorized for specified user's identity provider.");
        }
        if (loginHintToUse != null) {
            this.zoneAwareAuthzAuthenticationManager.setLoginHint(authentication, loginHintToUse);
        }
        if (loginHintToUse == null || loginHintToUse.getOrigin() == null || loginHintToUse.getOrigin().equals("uaa") || loginHintToUse.getOrigin().equals("ldap")) {
            return this.zoneAwareAuthzAuthenticationManager.authenticate(authentication);
        }
        return this.oidcPasswordGrant(authentication, (OIDCIdentityProviderDefinition)this.xoauthProviderProvisioning.retrieveByOrigin(loginHintToUse.getOrigin(), IdentityZoneHolder.get().getId()).getConfig());
    }

    private UaaLoginHint getUaaLoginHintForChainedAuth(List<String> allowedProviders) {
        UaaLoginHint loginHintToUse = null;
        if (allowedProviders.size() == 1) {
            loginHintToUse = new UaaLoginHint(allowedProviders.get(0));
        } else if (allowedProviders.contains("uaa")) {
            if (!allowedProviders.contains("ldap")) {
                loginHintToUse = new UaaLoginHint("uaa");
            }
        } else if (allowedProviders.contains("ldap")) {
            loginHintToUse = new UaaLoginHint("ldap");
        } else {
            if (allowedProviders.size() == 0) {
                throw new BadCredentialsException("The client is not authorized for any identity provider that supports password grant.");
            }
            throw new BadCredentialsException("The client is authorized for multiple identity providers that support password grant and could not determine which identity provider to use.");
        }
        return loginHintToUse;
    }

    private Authentication oidcPasswordGrant(Authentication authentication, OIDCIdentityProviderDefinition config) {
        String password;
        URL tokenUrl = config.getTokenUrl();
        String clientId = config.getRelyingPartyId();
        String clientSecret = config.getRelyingPartySecret();
        if (clientId == null || clientSecret == null) {
            throw new ProviderConfigurationException("External OpenID Connect provider configuration is missing relyingPartyId or relyingPartySecret.");
        }
        String userName = authentication.getPrincipal() instanceof String ? (String)authentication.getPrincipal() : null;
        String string = password = authentication.getCredentials() instanceof String ? (String)authentication.getCredentials() : null;
        if (userName == null || password == null) {
            throw new BadCredentialsException("Request is missing username or password.");
        }
        RestTemplate rt = config.isSkipSslValidation() ? this.restTemplateConfig.trustingRestTemplate() : this.restTemplateConfig.nonTrustingRestTemplate();
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(Arrays.asList(MediaType.APPLICATION_JSON));
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        String auth = clientId + ":" + clientSecret;
        headers.add("Authorization", "Basic " + Base64Utils.encodeToString((byte[])auth.getBytes()));
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        params.add((Object)"grant_type", (Object)"password");
        params.add((Object)"response_type", (Object)"id_token");
        params.add((Object)"username", (Object)userName);
        params.add((Object)"password", (Object)password);
        List prompts = config.getPrompts();
        ArrayList<String> promptsToInclude = new ArrayList<String>();
        if (prompts != null) {
            for (Object prompt : prompts) {
                if ("username".equals(prompt.getName()) || "password".equals(prompt.getName()) || "passcode".equals(prompt.getName())) continue;
                promptsToInclude.add(prompt.getName());
            }
        }
        if (authentication.getDetails() instanceof UaaAuthenticationDetails) {
            UaaAuthenticationDetails details = (UaaAuthenticationDetails)authentication.getDetails();
            for (String prompt : promptsToInclude) {
                String[] values = details.getParameterMap().get(prompt);
                if (values == null || values.length != 1 || !StringUtils.hasText((String)values[0])) continue;
                params.add((Object)prompt, (Object)values[0]);
            }
        }
        HttpEntity request = new HttpEntity((Object)params, (MultiValueMap)headers);
        String idToken = null;
        try {
            ResponseEntity tokenResponse = rt.exchange(tokenUrl.toString(), HttpMethod.POST, request, (ParameterizedTypeReference)new ParameterizedTypeReference<Map<String, String>>(){}, new Object[0]);
            if (tokenResponse.hasBody()) {
                Map body = (Map)tokenResponse.getBody();
                idToken = (String)body.get("id_token");
            }
        }
        catch (HttpClientErrorException e) {
            throw new BadCredentialsException(e.getResponseBodyAsString(), (Throwable)e);
        }
        if (idToken == null) {
            throw new BadCredentialsException("Could not obtain id_token from external OpenID Connect provider.");
        }
        XOAuthCodeToken token = new XOAuthCodeToken(null, null, null, idToken, null, null);
        Authentication authResult = this.xoAuthAuthenticationManager.authenticate(token);
        return authResult;
    }

    private boolean providerSupportsPasswordGrant(IdentityProvider provider) {
        if ("uaa".equals(provider.getType()) || "ldap".equals(provider.getType())) {
            return true;
        }
        if (!"oidc1.0".equals(provider.getType()) || !(provider.getConfig() instanceof OIDCIdentityProviderDefinition)) {
            return false;
        }
        OIDCIdentityProviderDefinition config = (OIDCIdentityProviderDefinition)provider.getConfig();
        return config.isPasswordGrantEnabled();
    }

    private List<String> getAllowedProviders() {
        Authentication clientAuth = SecurityContextHolder.getContext().getAuthentication();
        if (clientAuth == null) {
            throw new BadCredentialsException("No client authentication found.");
        }
        String clientId = clientAuth.getName();
        ClientDetails clientDetails = this.clientDetailsService.loadClientByClientId(clientId, IdentityZoneHolder.get().getId());
        List allowedProviders = (List)clientDetails.getAdditionalInformation().get("allowedproviders");
        return allowedProviders;
    }
}

