/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.authentication;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.cloudfoundry.identity.uaa.util.JsonUtils;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.util.StringUtils;

public class SamlRedirectLogoutHandler
implements LogoutSuccessHandler {
    private final LogoutSuccessHandler wrappedHandler;

    public SamlRedirectLogoutHandler(LogoutSuccessHandler wrappedHandler) {
        this.wrappedHandler = wrappedHandler;
    }

    public void onLogoutSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
        RequestWrapper requestWrapper = new RequestWrapper(request);
        String relayState = request.getParameter("RelayState");
        Map params = (Map)JsonUtils.readValue((String)relayState, (TypeReference)new TypeReference<Map<String, String>>(){});
        if (params != null) {
            String clientId;
            String redirect = (String)params.get("redirect");
            if (StringUtils.hasText((String)redirect)) {
                requestWrapper.setParameter("redirect", redirect);
            }
            if (StringUtils.hasText((String)(clientId = (String)params.get("client_id")))) {
                requestWrapper.setParameter("client_id", clientId);
            }
        }
        this.wrappedHandler.onLogoutSuccess((HttpServletRequest)requestWrapper, response, authentication);
    }

    private static class RequestWrapper
    extends HttpServletRequestWrapper {
        private final Map<String, String[]> parameterMap;

        public RequestWrapper(HttpServletRequest request) {
            super(request);
            this.parameterMap = new HashMap<String, String[]>(request.getParameterMap());
        }

        public void setParameter(String name, String ... value) {
            this.parameterMap.put(name, value);
        }

        public String getParameter(String name) {
            String[] values = this.parameterMap.get(name);
            return values != null && values.length > 0 ? values[0] : null;
        }

        public Map<String, String[]> getParameterMap() {
            return this.parameterMap;
        }

        public Enumeration<String> getParameterNames() {
            return new Enumeration<String>(){
                Iterator<String> iterator;
                {
                    this.iterator = parameterMap.keySet().iterator();
                }

                @Override
                public boolean hasMoreElements() {
                    return this.iterator.hasNext();
                }

                @Override
                public String nextElement() {
                    return this.iterator.next();
                }
            };
        }

        public String[] getParameterValues(String name) {
            return this.parameterMap.get(name);
        }
    }
}

