/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.operations.applications;

import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import org.cloudfoundry.AllowNulls;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.operations.applications.ApplicationHealthCheck;
import org.cloudfoundry.operations.applications.Docker;
import org.cloudfoundry.operations.applications.Route;
import org.immutables.value.Value;

@Value.Immutable
abstract class _ApplicationManifest {
    _ApplicationManifest() {
    }

    @Value.Check
    void check() {
        if (this.getRoutes() != null) {
            if (this.getHosts() != null) {
                throw new IllegalStateException("routes and hosts cannot both be set");
            }
            if (this.getDomains() != null) {
                throw new IllegalStateException("routes and domains cannot both be set");
            }
            if (this.getNoHostname() != null) {
                throw new IllegalStateException("routes and noHostname cannot both be set");
            }
        }
        if (this.getDocker() != null) {
            if (this.getDocker().getImage() != null && this.getBuildpacks() != null && !this.getBuildpacks().isEmpty()) {
                throw new IllegalStateException("docker image and buildpack cannot both be set");
            }
            if (this.getDocker().getImage() != null && this.getPath() != null) {
                throw new IllegalStateException("docker image and path cannot both be set");
            }
            if (this.getDocker().getImage() == null && (this.getDocker().getUsername() != null || this.getDocker().getPassword() != null)) {
                throw new IllegalStateException("docker credentials require docker image to be set");
            }
            if (this.getDocker().getPassword() != null && this.getDocker().getUsername() == null) {
                throw new IllegalStateException("Docker password requires username");
            }
            if (this.getDocker().getPassword() == null && this.getDocker().getUsername() != null) {
                throw new IllegalStateException("Docker username requires password");
            }
        }
    }

    @Nullable
    abstract List<String> getBuildpacks();

    @Nullable
    abstract String getCommand();

    @Nullable
    abstract Integer getDisk();

    @Nullable
    abstract Docker getDocker();

    @Nullable
    abstract List<String> getDomains();

    @AllowNulls
    @Nullable
    abstract Map<String, Object> getEnvironmentVariables();

    @Nullable
    abstract String getHealthCheckHttpEndpoint();

    @Nullable
    abstract ApplicationHealthCheck getHealthCheckType();

    @Nullable
    abstract List<String> getHosts();

    @Nullable
    abstract Integer getInstances();

    @Nullable
    abstract Integer getMemory();

    abstract String getName();

    @Nullable
    abstract Boolean getNoHostname();

    @Nullable
    abstract Boolean getNoRoute();

    @Nullable
    abstract Path getPath();

    @Nullable
    abstract Boolean getRandomRoute();

    @Nullable
    abstract String getRoutePath();

    @Nullable
    abstract List<Route> getRoutes();

    @Nullable
    abstract List<String> getServices();

    @Nullable
    abstract String getStack();

    @Nullable
    abstract Integer getTimeout();
}

