/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.operations.useradmin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.operations.useradmin._SpaceUsers;

public final class SpaceUsers
extends _SpaceUsers {
    private final List<String> auditors;
    private final List<String> developers;
    private final List<String> managers;

    private SpaceUsers(Builder builder) {
        this.auditors = SpaceUsers.createUnmodifiableList(true, builder.auditors);
        this.developers = SpaceUsers.createUnmodifiableList(true, builder.developers);
        this.managers = SpaceUsers.createUnmodifiableList(true, builder.managers);
    }

    @Override
    public List<String> getAuditors() {
        return this.auditors;
    }

    @Override
    public List<String> getDevelopers() {
        return this.developers;
    }

    @Override
    public List<String> getManagers() {
        return this.managers;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof SpaceUsers && this.equalTo((SpaceUsers)another);
    }

    private boolean equalTo(SpaceUsers another) {
        return this.auditors.equals(another.auditors) && this.developers.equals(another.developers) && this.managers.equals(another.managers);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.auditors.hashCode();
        h += (h << 5) + this.developers.hashCode();
        h += (h << 5) + this.managers.hashCode();
        return h;
    }

    public String toString() {
        return "SpaceUsers{auditors=" + this.auditors + ", developers=" + this.developers + ", managers=" + this.managers + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private List<String> auditors = new ArrayList<String>();
        private List<String> developers = new ArrayList<String>();
        private List<String> managers = new ArrayList<String>();

        private Builder() {
        }

        public final Builder from(SpaceUsers instance) {
            return this.from((_SpaceUsers)instance);
        }

        final Builder from(_SpaceUsers instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllAuditors(instance.getAuditors());
            this.addAllDevelopers(instance.getDevelopers());
            this.addAllManagers(instance.getManagers());
            return this;
        }

        public final Builder auditor(String element) {
            this.auditors.add(Objects.requireNonNull(element, "auditors element"));
            return this;
        }

        public final Builder auditor(String ... elements) {
            for (String element : elements) {
                this.auditors.add(Objects.requireNonNull(element, "auditors element"));
            }
            return this;
        }

        public final Builder auditors(Iterable<String> elements) {
            this.auditors.clear();
            return this.addAllAuditors(elements);
        }

        public final Builder addAllAuditors(Iterable<String> elements) {
            for (String element : elements) {
                this.auditors.add(Objects.requireNonNull(element, "auditors element"));
            }
            return this;
        }

        public final Builder developer(String element) {
            this.developers.add(Objects.requireNonNull(element, "developers element"));
            return this;
        }

        public final Builder developer(String ... elements) {
            for (String element : elements) {
                this.developers.add(Objects.requireNonNull(element, "developers element"));
            }
            return this;
        }

        public final Builder developers(Iterable<String> elements) {
            this.developers.clear();
            return this.addAllDevelopers(elements);
        }

        public final Builder addAllDevelopers(Iterable<String> elements) {
            for (String element : elements) {
                this.developers.add(Objects.requireNonNull(element, "developers element"));
            }
            return this;
        }

        public final Builder manager(String element) {
            this.managers.add(Objects.requireNonNull(element, "managers element"));
            return this;
        }

        public final Builder manager(String ... elements) {
            for (String element : elements) {
                this.managers.add(Objects.requireNonNull(element, "managers element"));
            }
            return this;
        }

        public final Builder managers(Iterable<String> elements) {
            this.managers.clear();
            return this.addAllManagers(elements);
        }

        public final Builder addAllManagers(Iterable<String> elements) {
            for (String element : elements) {
                this.managers.add(Objects.requireNonNull(element, "managers element"));
            }
            return this;
        }

        public SpaceUsers build() {
            return new SpaceUsers(this);
        }
    }
}

