/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.operations.serviceadmin;

import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.operations.serviceadmin._ServiceBroker;

public final class ServiceBroker
extends _ServiceBroker {
    private final String id;
    private final String name;
    private final String url;

    private ServiceBroker(Builder builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.url = builder.url;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ServiceBroker && this.equalTo((ServiceBroker)another);
    }

    private boolean equalTo(ServiceBroker another) {
        return this.id.equals(another.id) && this.name.equals(another.name) && this.url.equals(another.url);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.url.hashCode();
        return h;
    }

    public String toString() {
        return "ServiceBroker{id=" + this.id + ", name=" + this.name + ", url=" + this.url + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_NAME = 2L;
        private static final long INIT_BIT_URL = 4L;
        private long initBits = 7L;
        private String id;
        private String name;
        private String url;

        private Builder() {
        }

        public final Builder from(ServiceBroker instance) {
            return this.from((_ServiceBroker)instance);
        }

        final Builder from(_ServiceBroker instance) {
            Objects.requireNonNull(instance, "instance");
            this.id(instance.getId());
            this.name(instance.getName());
            this.url(instance.getUrl());
            return this;
        }

        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder url(String url) {
            this.url = Objects.requireNonNull(url, "url");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ServiceBroker build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ServiceBroker(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("url");
            }
            return "Cannot build ServiceBroker, some of required attributes are not set " + attributes;
        }
    }
}

