/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.operations.applications;

import java.nio.file.Path;
import java.time.Duration;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.operations.applications.ApplicationHealthCheck;
import org.immutables.value.Value;

@Value.Immutable
abstract class _PushApplicationRequest {
    _PushApplicationRequest() {
    }

    @Value.Check
    void check() {
        if (this.getApplication() == null && this.getPath() == null && this.getDockerImage() == null) {
            throw new IllegalStateException("One of path or dockerImage must be supplied");
        }
        if ((this.getApplication() != null || this.getPath() != null) && this.getDockerImage() != null) {
            throw new IllegalStateException("Only one of path or dockerImage can be supplied");
        }
        if (this.getDockerImage() == null && (this.getDockerPassword() != null || this.getDockerUsername() != null)) {
            throw new IllegalStateException("Docker credentials require docker image to be set");
        }
        if (this.getDockerPassword() != null && this.getDockerUsername() == null) {
            throw new IllegalStateException("Docker password requires username");
        }
        if (this.getDockerPassword() == null && this.getDockerUsername() != null) {
            throw new IllegalStateException("Docker username requires password");
        }
    }

    @Deprecated
    @Nullable
    abstract Path getApplication();

    @Nullable
    abstract String getBuildpack();

    @Nullable
    abstract String getCommand();

    @Nullable
    abstract Integer getDiskQuota();

    @Nullable
    abstract String getDockerImage();

    @Nullable
    abstract String getDockerPassword();

    @Nullable
    abstract String getDockerUsername();

    @Nullable
    abstract String getDomain();

    @Nullable
    abstract ApplicationHealthCheck getHealthCheckType();

    @Nullable
    abstract String getHost();

    @Nullable
    abstract Integer getInstances();

    @Nullable
    abstract Integer getMemory();

    abstract String getName();

    @Nullable
    abstract Boolean getNoHostname();

    @Nullable
    abstract Boolean getNoRoute();

    @Nullable
    abstract Boolean getNoStart();

    @Nullable
    abstract Path getPath();

    @Nullable
    abstract Boolean getRandomRoute();

    @Nullable
    abstract String getRoutePath();

    @Nullable
    abstract String getStack();

    @Value.Default
    Duration getStagingTimeout() {
        return Duration.ofMinutes(5L);
    }

    @Value.Default
    Duration getStartupTimeout() {
        return Duration.ofMinutes(5L);
    }

    @Nullable
    abstract Integer getTimeout();
}

