/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.operations;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.CloudFoundryClient;
import org.cloudfoundry.doppler.DopplerClient;
import org.cloudfoundry.networking.NetworkingClient;
import org.cloudfoundry.operations._DefaultCloudFoundryOperations;
import org.cloudfoundry.operations.advanced.Advanced;
import org.cloudfoundry.operations.applications.Applications;
import org.cloudfoundry.operations.buildpacks.Buildpacks;
import org.cloudfoundry.operations.domains.Domains;
import org.cloudfoundry.operations.networkpolicies.NetworkPolicies;
import org.cloudfoundry.operations.organizationadmin.OrganizationAdmin;
import org.cloudfoundry.operations.organizations.Organizations;
import org.cloudfoundry.operations.routes.Routes;
import org.cloudfoundry.operations.serviceadmin.ServiceAdmin;
import org.cloudfoundry.operations.services.Services;
import org.cloudfoundry.operations.spaceadmin.SpaceAdmin;
import org.cloudfoundry.operations.spaces.Spaces;
import org.cloudfoundry.operations.stacks.Stacks;
import org.cloudfoundry.operations.useradmin.UserAdmin;
import org.cloudfoundry.routing.RoutingClient;
import org.cloudfoundry.uaa.UaaClient;
import reactor.core.publisher.Mono;

public final class DefaultCloudFoundryOperations
extends _DefaultCloudFoundryOperations {
    private final Advanced advanced;
    private final Applications applications;
    private final Buildpacks buildpacks;
    private final Domains domains;
    private final NetworkPolicies networkPolicies;
    private final OrganizationAdmin organizationAdmin;
    private final Organizations organizations;
    private final Routes routes;
    private final ServiceAdmin serviceAdmin;
    private final Services services;
    private final SpaceAdmin spaceAdmin;
    private final Spaces spaces;
    private final Stacks stacks;
    private final UserAdmin userAdmin;
    private final Duration cacheDuration;
    @Nullable
    private final CloudFoundryClient cloudFoundryClient;
    private final Mono<CloudFoundryClient> cloudFoundryClientPublisher;
    @Nullable
    private final DopplerClient dopplerClient;
    private final Mono<DopplerClient> dopplerClientPublisher;
    @Nullable
    private final NetworkingClient networkingClient;
    private final Mono<NetworkingClient> networkingClientPublisher;
    @Nullable
    private final String organization;
    private final Mono<String> organizationId;
    @Nullable
    private final RoutingClient routingClient;
    private final Mono<RoutingClient> routingClientPublisher;
    @Nullable
    private final String space;
    private final Mono<String> spaceId;
    @Nullable
    private final UaaClient uaaClient;
    private final Mono<UaaClient> uaaClientPublisher;
    private final Mono<String> username;
    private static final int STAGE_INITIALIZING = -1;
    private static final int STAGE_UNINITIALIZED = 0;
    private static final int STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private DefaultCloudFoundryOperations(Builder builder) {
        this.cacheDuration = builder.cacheDuration;
        this.cloudFoundryClient = builder.cloudFoundryClient;
        this.dopplerClient = builder.dopplerClient;
        this.networkingClient = builder.networkingClient;
        this.organization = builder.organization;
        this.routingClient = builder.routingClient;
        this.space = builder.space;
        this.uaaClient = builder.uaaClient;
        this.advanced = this.initShim.advanced();
        this.applications = this.initShim.applications();
        this.buildpacks = this.initShim.buildpacks();
        this.domains = this.initShim.domains();
        this.networkPolicies = this.initShim.networkPolicies();
        this.organizationAdmin = this.initShim.organizationAdmin();
        this.organizations = this.initShim.organizations();
        this.routes = this.initShim.routes();
        this.serviceAdmin = this.initShim.serviceAdmin();
        this.services = this.initShim.services();
        this.spaceAdmin = this.initShim.spaceAdmin();
        this.spaces = this.initShim.spaces();
        this.stacks = this.initShim.stacks();
        this.userAdmin = this.initShim.userAdmin();
        this.cloudFoundryClientPublisher = this.initShim.getCloudFoundryClientPublisher();
        this.dopplerClientPublisher = this.initShim.getDopplerClientPublisher();
        this.networkingClientPublisher = this.initShim.getNetworkingClientPublisher();
        this.organizationId = this.initShim.getOrganizationId();
        this.routingClientPublisher = this.initShim.getRoutingClientPublisher();
        this.spaceId = this.initShim.getSpaceId();
        this.uaaClientPublisher = this.initShim.getUaaClientPublisher();
        this.username = this.initShim.getUsername();
        this.initShim = null;
    }

    @Override
    public Advanced advanced() {
        InitShim shim = this.initShim;
        return shim != null ? shim.advanced() : this.advanced;
    }

    @Override
    public Applications applications() {
        InitShim shim = this.initShim;
        return shim != null ? shim.applications() : this.applications;
    }

    @Override
    public Buildpacks buildpacks() {
        InitShim shim = this.initShim;
        return shim != null ? shim.buildpacks() : this.buildpacks;
    }

    @Override
    public Domains domains() {
        InitShim shim = this.initShim;
        return shim != null ? shim.domains() : this.domains;
    }

    @Override
    public NetworkPolicies networkPolicies() {
        InitShim shim = this.initShim;
        return shim != null ? shim.networkPolicies() : this.networkPolicies;
    }

    @Override
    public OrganizationAdmin organizationAdmin() {
        InitShim shim = this.initShim;
        return shim != null ? shim.organizationAdmin() : this.organizationAdmin;
    }

    @Override
    public Organizations organizations() {
        InitShim shim = this.initShim;
        return shim != null ? shim.organizations() : this.organizations;
    }

    @Override
    public Routes routes() {
        InitShim shim = this.initShim;
        return shim != null ? shim.routes() : this.routes;
    }

    @Override
    public ServiceAdmin serviceAdmin() {
        InitShim shim = this.initShim;
        return shim != null ? shim.serviceAdmin() : this.serviceAdmin;
    }

    @Override
    public Services services() {
        InitShim shim = this.initShim;
        return shim != null ? shim.services() : this.services;
    }

    @Override
    public SpaceAdmin spaceAdmin() {
        InitShim shim = this.initShim;
        return shim != null ? shim.spaceAdmin() : this.spaceAdmin;
    }

    @Override
    public Spaces spaces() {
        InitShim shim = this.initShim;
        return shim != null ? shim.spaces() : this.spaces;
    }

    @Override
    public Stacks stacks() {
        InitShim shim = this.initShim;
        return shim != null ? shim.stacks() : this.stacks;
    }

    @Override
    public UserAdmin userAdmin() {
        InitShim shim = this.initShim;
        return shim != null ? shim.userAdmin() : this.userAdmin;
    }

    @Override
    public Optional<Duration> getCacheDuration() {
        return Optional.ofNullable(this.cacheDuration);
    }

    @Override
    @Nullable
    public CloudFoundryClient getCloudFoundryClient() {
        return this.cloudFoundryClient;
    }

    @Override
    public Mono<CloudFoundryClient> getCloudFoundryClientPublisher() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getCloudFoundryClientPublisher() : this.cloudFoundryClientPublisher;
    }

    @Override
    @Nullable
    public DopplerClient getDopplerClient() {
        return this.dopplerClient;
    }

    @Override
    public Mono<DopplerClient> getDopplerClientPublisher() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getDopplerClientPublisher() : this.dopplerClientPublisher;
    }

    @Override
    @Nullable
    public NetworkingClient getNetworkingClient() {
        return this.networkingClient;
    }

    @Override
    public Mono<NetworkingClient> getNetworkingClientPublisher() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getNetworkingClientPublisher() : this.networkingClientPublisher;
    }

    @Override
    @Nullable
    public String getOrganization() {
        return this.organization;
    }

    @Override
    public Mono<String> getOrganizationId() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getOrganizationId() : this.organizationId;
    }

    @Override
    @Nullable
    public RoutingClient getRoutingClient() {
        return this.routingClient;
    }

    @Override
    public Mono<RoutingClient> getRoutingClientPublisher() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getRoutingClientPublisher() : this.routingClientPublisher;
    }

    @Override
    @Nullable
    public String getSpace() {
        return this.space;
    }

    @Override
    public Mono<String> getSpaceId() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getSpaceId() : this.spaceId;
    }

    @Override
    @Nullable
    public UaaClient getUaaClient() {
        return this.uaaClient;
    }

    @Override
    public Mono<UaaClient> getUaaClientPublisher() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getUaaClientPublisher() : this.uaaClientPublisher;
    }

    @Override
    public Mono<String> getUsername() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getUsername() : this.username;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof DefaultCloudFoundryOperations && this.equalTo((DefaultCloudFoundryOperations)another);
    }

    private boolean equalTo(DefaultCloudFoundryOperations another) {
        return this.advanced.equals(another.advanced) && this.applications.equals(another.applications) && this.buildpacks.equals(another.buildpacks) && this.domains.equals(another.domains) && this.networkPolicies.equals(another.networkPolicies) && this.organizationAdmin.equals(another.organizationAdmin) && this.organizations.equals(another.organizations) && this.routes.equals(another.routes) && this.serviceAdmin.equals(another.serviceAdmin) && this.services.equals(another.services) && this.spaceAdmin.equals(another.spaceAdmin) && this.spaces.equals(another.spaces) && this.stacks.equals(another.stacks) && this.userAdmin.equals(another.userAdmin) && Objects.equals(this.cacheDuration, another.cacheDuration) && Objects.equals(this.cloudFoundryClient, another.cloudFoundryClient) && this.cloudFoundryClientPublisher.equals(another.cloudFoundryClientPublisher) && Objects.equals(this.dopplerClient, another.dopplerClient) && this.dopplerClientPublisher.equals(another.dopplerClientPublisher) && Objects.equals(this.networkingClient, another.networkingClient) && this.networkingClientPublisher.equals(another.networkingClientPublisher) && Objects.equals(this.organization, another.organization) && this.organizationId.equals(another.organizationId) && Objects.equals(this.routingClient, another.routingClient) && this.routingClientPublisher.equals(another.routingClientPublisher) && Objects.equals(this.space, another.space) && this.spaceId.equals(another.spaceId) && Objects.equals(this.uaaClient, another.uaaClient) && this.uaaClientPublisher.equals(another.uaaClientPublisher) && this.username.equals(another.username);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.advanced.hashCode();
        h += (h << 5) + this.applications.hashCode();
        h += (h << 5) + this.buildpacks.hashCode();
        h += (h << 5) + this.domains.hashCode();
        h += (h << 5) + this.networkPolicies.hashCode();
        h += (h << 5) + this.organizationAdmin.hashCode();
        h += (h << 5) + this.organizations.hashCode();
        h += (h << 5) + this.routes.hashCode();
        h += (h << 5) + this.serviceAdmin.hashCode();
        h += (h << 5) + this.services.hashCode();
        h += (h << 5) + this.spaceAdmin.hashCode();
        h += (h << 5) + this.spaces.hashCode();
        h += (h << 5) + this.stacks.hashCode();
        h += (h << 5) + this.userAdmin.hashCode();
        h += (h << 5) + Objects.hashCode(this.cacheDuration);
        h += (h << 5) + Objects.hashCode(this.cloudFoundryClient);
        h += (h << 5) + this.cloudFoundryClientPublisher.hashCode();
        h += (h << 5) + Objects.hashCode(this.dopplerClient);
        h += (h << 5) + this.dopplerClientPublisher.hashCode();
        h += (h << 5) + Objects.hashCode(this.networkingClient);
        h += (h << 5) + this.networkingClientPublisher.hashCode();
        h += (h << 5) + Objects.hashCode(this.organization);
        h += (h << 5) + this.organizationId.hashCode();
        h += (h << 5) + Objects.hashCode(this.routingClient);
        h += (h << 5) + this.routingClientPublisher.hashCode();
        h += (h << 5) + Objects.hashCode(this.space);
        h += (h << 5) + this.spaceId.hashCode();
        h += (h << 5) + Objects.hashCode(this.uaaClient);
        h += (h << 5) + this.uaaClientPublisher.hashCode();
        h += (h << 5) + this.username.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("DefaultCloudFoundryOperations{");
        builder.append("advanced=").append(this.advanced);
        builder.append(", ");
        builder.append("applications=").append(this.applications);
        builder.append(", ");
        builder.append("buildpacks=").append(this.buildpacks);
        builder.append(", ");
        builder.append("domains=").append(this.domains);
        builder.append(", ");
        builder.append("networkPolicies=").append(this.networkPolicies);
        builder.append(", ");
        builder.append("organizationAdmin=").append(this.organizationAdmin);
        builder.append(", ");
        builder.append("organizations=").append(this.organizations);
        builder.append(", ");
        builder.append("routes=").append(this.routes);
        builder.append(", ");
        builder.append("serviceAdmin=").append(this.serviceAdmin);
        builder.append(", ");
        builder.append("services=").append(this.services);
        builder.append(", ");
        builder.append("spaceAdmin=").append(this.spaceAdmin);
        builder.append(", ");
        builder.append("spaces=").append(this.spaces);
        builder.append(", ");
        builder.append("stacks=").append(this.stacks);
        builder.append(", ");
        builder.append("userAdmin=").append(this.userAdmin);
        if (this.cacheDuration != null) {
            builder.append(", ");
            builder.append("cacheDuration=").append(this.cacheDuration);
        }
        if (this.cloudFoundryClient != null) {
            builder.append(", ");
            builder.append("cloudFoundryClient=").append(this.cloudFoundryClient);
        }
        builder.append(", ");
        builder.append("cloudFoundryClientPublisher=").append(this.cloudFoundryClientPublisher);
        if (this.dopplerClient != null) {
            builder.append(", ");
            builder.append("dopplerClient=").append(this.dopplerClient);
        }
        builder.append(", ");
        builder.append("dopplerClientPublisher=").append(this.dopplerClientPublisher);
        if (this.networkingClient != null) {
            builder.append(", ");
            builder.append("networkingClient=").append(this.networkingClient);
        }
        builder.append(", ");
        builder.append("networkingClientPublisher=").append(this.networkingClientPublisher);
        if (this.organization != null) {
            builder.append(", ");
            builder.append("organization=").append(this.organization);
        }
        builder.append(", ");
        builder.append("organizationId=").append(this.organizationId);
        if (this.routingClient != null) {
            builder.append(", ");
            builder.append("routingClient=").append(this.routingClient);
        }
        builder.append(", ");
        builder.append("routingClientPublisher=").append(this.routingClientPublisher);
        if (this.space != null) {
            builder.append(", ");
            builder.append("space=").append(this.space);
        }
        builder.append(", ");
        builder.append("spaceId=").append(this.spaceId);
        if (this.uaaClient != null) {
            builder.append(", ");
            builder.append("uaaClient=").append(this.uaaClient);
        }
        builder.append(", ");
        builder.append("uaaClientPublisher=").append(this.uaaClientPublisher);
        builder.append(", ");
        builder.append("username=").append(this.username);
        return builder.append("}").toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Duration cacheDuration;
        private CloudFoundryClient cloudFoundryClient;
        private DopplerClient dopplerClient;
        private NetworkingClient networkingClient;
        private String organization;
        private RoutingClient routingClient;
        private String space;
        private UaaClient uaaClient;

        private Builder() {
        }

        public final Builder from(DefaultCloudFoundryOperations instance) {
            return this.from((_DefaultCloudFoundryOperations)instance);
        }

        final Builder from(_DefaultCloudFoundryOperations instance) {
            UaaClient uaaClientValue;
            String spaceValue;
            RoutingClient routingClientValue;
            String organizationValue;
            NetworkingClient networkingClientValue;
            DopplerClient dopplerClientValue;
            CloudFoundryClient cloudFoundryClientValue;
            Objects.requireNonNull(instance, "instance");
            Optional<Duration> cacheDurationOptional = instance.getCacheDuration();
            if (cacheDurationOptional.isPresent()) {
                this.cacheDuration(cacheDurationOptional);
            }
            if ((cloudFoundryClientValue = instance.getCloudFoundryClient()) != null) {
                this.cloudFoundryClient(cloudFoundryClientValue);
            }
            if ((dopplerClientValue = instance.getDopplerClient()) != null) {
                this.dopplerClient(dopplerClientValue);
            }
            if ((networkingClientValue = instance.getNetworkingClient()) != null) {
                this.networkingClient(networkingClientValue);
            }
            if ((organizationValue = instance.getOrganization()) != null) {
                this.organization(organizationValue);
            }
            if ((routingClientValue = instance.getRoutingClient()) != null) {
                this.routingClient(routingClientValue);
            }
            if ((spaceValue = instance.getSpace()) != null) {
                this.space(spaceValue);
            }
            if ((uaaClientValue = instance.getUaaClient()) != null) {
                this.uaaClient(uaaClientValue);
            }
            return this;
        }

        public final Builder cacheDuration(Duration cacheDuration) {
            this.cacheDuration = Objects.requireNonNull(cacheDuration, "cacheDuration");
            return this;
        }

        public final Builder cacheDuration(Optional<? extends Duration> cacheDuration) {
            this.cacheDuration = cacheDuration.orElse(null);
            return this;
        }

        public final Builder cloudFoundryClient(@Nullable CloudFoundryClient cloudFoundryClient) {
            this.cloudFoundryClient = cloudFoundryClient;
            return this;
        }

        public final Builder dopplerClient(@Nullable DopplerClient dopplerClient) {
            this.dopplerClient = dopplerClient;
            return this;
        }

        public final Builder networkingClient(@Nullable NetworkingClient networkingClient) {
            this.networkingClient = networkingClient;
            return this;
        }

        public final Builder organization(@Nullable String organization) {
            this.organization = organization;
            return this;
        }

        public final Builder routingClient(@Nullable RoutingClient routingClient) {
            this.routingClient = routingClient;
            return this;
        }

        public final Builder space(@Nullable String space) {
            this.space = space;
            return this;
        }

        public final Builder uaaClient(@Nullable UaaClient uaaClient) {
            this.uaaClient = uaaClient;
            return this;
        }

        public DefaultCloudFoundryOperations build() {
            return new DefaultCloudFoundryOperations(this);
        }
    }

    private final class InitShim {
        private Advanced advanced;
        private int advancedBuildStage;
        private Applications applications;
        private int applicationsBuildStage;
        private Buildpacks buildpacks;
        private int buildpacksBuildStage;
        private Domains domains;
        private int domainsBuildStage;
        private NetworkPolicies networkPolicies;
        private int networkPoliciesBuildStage;
        private OrganizationAdmin organizationAdmin;
        private int organizationAdminBuildStage;
        private Organizations organizations;
        private int organizationsBuildStage;
        private Routes routes;
        private int routesBuildStage;
        private ServiceAdmin serviceAdmin;
        private int serviceAdminBuildStage;
        private Services services;
        private int servicesBuildStage;
        private SpaceAdmin spaceAdmin;
        private int spaceAdminBuildStage;
        private Spaces spaces;
        private int spacesBuildStage;
        private Stacks stacks;
        private int stacksBuildStage;
        private UserAdmin userAdmin;
        private int userAdminBuildStage;
        private Mono<CloudFoundryClient> cloudFoundryClientPublisher;
        private int cloudFoundryClientPublisherBuildStage;
        private Mono<DopplerClient> dopplerClientPublisher;
        private int dopplerClientPublisherBuildStage;
        private Mono<NetworkingClient> networkingClientPublisher;
        private int networkingClientPublisherBuildStage;
        private Mono<String> organizationId;
        private int organizationIdBuildStage;
        private Mono<RoutingClient> routingClientPublisher;
        private int routingClientPublisherBuildStage;
        private Mono<String> spaceId;
        private int spaceIdBuildStage;
        private Mono<UaaClient> uaaClientPublisher;
        private int uaaClientPublisherBuildStage;
        private Mono<String> username;
        private int usernameBuildStage;

        private InitShim() {
        }

        Advanced advanced() {
            if (this.advancedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.advancedBuildStage == 0) {
                this.advancedBuildStage = -1;
                this.advanced = Objects.requireNonNull(DefaultCloudFoundryOperations.super.advanced(), "advanced");
                this.advancedBuildStage = 1;
            }
            return this.advanced;
        }

        Applications applications() {
            if (this.applicationsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.applicationsBuildStage == 0) {
                this.applicationsBuildStage = -1;
                this.applications = Objects.requireNonNull(DefaultCloudFoundryOperations.super.applications(), "applications");
                this.applicationsBuildStage = 1;
            }
            return this.applications;
        }

        Buildpacks buildpacks() {
            if (this.buildpacksBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.buildpacksBuildStage == 0) {
                this.buildpacksBuildStage = -1;
                this.buildpacks = Objects.requireNonNull(DefaultCloudFoundryOperations.super.buildpacks(), "buildpacks");
                this.buildpacksBuildStage = 1;
            }
            return this.buildpacks;
        }

        Domains domains() {
            if (this.domainsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.domainsBuildStage == 0) {
                this.domainsBuildStage = -1;
                this.domains = Objects.requireNonNull(DefaultCloudFoundryOperations.super.domains(), "domains");
                this.domainsBuildStage = 1;
            }
            return this.domains;
        }

        NetworkPolicies networkPolicies() {
            if (this.networkPoliciesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.networkPoliciesBuildStage == 0) {
                this.networkPoliciesBuildStage = -1;
                this.networkPolicies = Objects.requireNonNull(DefaultCloudFoundryOperations.super.networkPolicies(), "networkPolicies");
                this.networkPoliciesBuildStage = 1;
            }
            return this.networkPolicies;
        }

        OrganizationAdmin organizationAdmin() {
            if (this.organizationAdminBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.organizationAdminBuildStage == 0) {
                this.organizationAdminBuildStage = -1;
                this.organizationAdmin = Objects.requireNonNull(DefaultCloudFoundryOperations.super.organizationAdmin(), "organizationAdmin");
                this.organizationAdminBuildStage = 1;
            }
            return this.organizationAdmin;
        }

        Organizations organizations() {
            if (this.organizationsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.organizationsBuildStage == 0) {
                this.organizationsBuildStage = -1;
                this.organizations = Objects.requireNonNull(DefaultCloudFoundryOperations.super.organizations(), "organizations");
                this.organizationsBuildStage = 1;
            }
            return this.organizations;
        }

        Routes routes() {
            if (this.routesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.routesBuildStage == 0) {
                this.routesBuildStage = -1;
                this.routes = Objects.requireNonNull(DefaultCloudFoundryOperations.super.routes(), "routes");
                this.routesBuildStage = 1;
            }
            return this.routes;
        }

        ServiceAdmin serviceAdmin() {
            if (this.serviceAdminBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.serviceAdminBuildStage == 0) {
                this.serviceAdminBuildStage = -1;
                this.serviceAdmin = Objects.requireNonNull(DefaultCloudFoundryOperations.super.serviceAdmin(), "serviceAdmin");
                this.serviceAdminBuildStage = 1;
            }
            return this.serviceAdmin;
        }

        Services services() {
            if (this.servicesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.servicesBuildStage == 0) {
                this.servicesBuildStage = -1;
                this.services = Objects.requireNonNull(DefaultCloudFoundryOperations.super.services(), "services");
                this.servicesBuildStage = 1;
            }
            return this.services;
        }

        SpaceAdmin spaceAdmin() {
            if (this.spaceAdminBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.spaceAdminBuildStage == 0) {
                this.spaceAdminBuildStage = -1;
                this.spaceAdmin = Objects.requireNonNull(DefaultCloudFoundryOperations.super.spaceAdmin(), "spaceAdmin");
                this.spaceAdminBuildStage = 1;
            }
            return this.spaceAdmin;
        }

        Spaces spaces() {
            if (this.spacesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.spacesBuildStage == 0) {
                this.spacesBuildStage = -1;
                this.spaces = Objects.requireNonNull(DefaultCloudFoundryOperations.super.spaces(), "spaces");
                this.spacesBuildStage = 1;
            }
            return this.spaces;
        }

        Stacks stacks() {
            if (this.stacksBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.stacksBuildStage == 0) {
                this.stacksBuildStage = -1;
                this.stacks = Objects.requireNonNull(DefaultCloudFoundryOperations.super.stacks(), "stacks");
                this.stacksBuildStage = 1;
            }
            return this.stacks;
        }

        UserAdmin userAdmin() {
            if (this.userAdminBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.userAdminBuildStage == 0) {
                this.userAdminBuildStage = -1;
                this.userAdmin = Objects.requireNonNull(DefaultCloudFoundryOperations.super.userAdmin(), "userAdmin");
                this.userAdminBuildStage = 1;
            }
            return this.userAdmin;
        }

        Mono<CloudFoundryClient> getCloudFoundryClientPublisher() {
            if (this.cloudFoundryClientPublisherBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.cloudFoundryClientPublisherBuildStage == 0) {
                this.cloudFoundryClientPublisherBuildStage = -1;
                this.cloudFoundryClientPublisher = Objects.requireNonNull(DefaultCloudFoundryOperations.super.getCloudFoundryClientPublisher(), "cloudFoundryClientPublisher");
                this.cloudFoundryClientPublisherBuildStage = 1;
            }
            return this.cloudFoundryClientPublisher;
        }

        Mono<DopplerClient> getDopplerClientPublisher() {
            if (this.dopplerClientPublisherBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.dopplerClientPublisherBuildStage == 0) {
                this.dopplerClientPublisherBuildStage = -1;
                this.dopplerClientPublisher = Objects.requireNonNull(DefaultCloudFoundryOperations.super.getDopplerClientPublisher(), "dopplerClientPublisher");
                this.dopplerClientPublisherBuildStage = 1;
            }
            return this.dopplerClientPublisher;
        }

        Mono<NetworkingClient> getNetworkingClientPublisher() {
            if (this.networkingClientPublisherBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.networkingClientPublisherBuildStage == 0) {
                this.networkingClientPublisherBuildStage = -1;
                this.networkingClientPublisher = Objects.requireNonNull(DefaultCloudFoundryOperations.super.getNetworkingClientPublisher(), "networkingClientPublisher");
                this.networkingClientPublisherBuildStage = 1;
            }
            return this.networkingClientPublisher;
        }

        Mono<String> getOrganizationId() {
            if (this.organizationIdBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.organizationIdBuildStage == 0) {
                this.organizationIdBuildStage = -1;
                this.organizationId = Objects.requireNonNull(DefaultCloudFoundryOperations.super.getOrganizationId(), "organizationId");
                this.organizationIdBuildStage = 1;
            }
            return this.organizationId;
        }

        Mono<RoutingClient> getRoutingClientPublisher() {
            if (this.routingClientPublisherBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.routingClientPublisherBuildStage == 0) {
                this.routingClientPublisherBuildStage = -1;
                this.routingClientPublisher = Objects.requireNonNull(DefaultCloudFoundryOperations.super.getRoutingClientPublisher(), "routingClientPublisher");
                this.routingClientPublisherBuildStage = 1;
            }
            return this.routingClientPublisher;
        }

        Mono<String> getSpaceId() {
            if (this.spaceIdBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.spaceIdBuildStage == 0) {
                this.spaceIdBuildStage = -1;
                this.spaceId = Objects.requireNonNull(DefaultCloudFoundryOperations.super.getSpaceId(), "spaceId");
                this.spaceIdBuildStage = 1;
            }
            return this.spaceId;
        }

        Mono<UaaClient> getUaaClientPublisher() {
            if (this.uaaClientPublisherBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.uaaClientPublisherBuildStage == 0) {
                this.uaaClientPublisherBuildStage = -1;
                this.uaaClientPublisher = Objects.requireNonNull(DefaultCloudFoundryOperations.super.getUaaClientPublisher(), "uaaClientPublisher");
                this.uaaClientPublisherBuildStage = 1;
            }
            return this.uaaClientPublisher;
        }

        Mono<String> getUsername() {
            if (this.usernameBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.usernameBuildStage == 0) {
                this.usernameBuildStage = -1;
                this.username = Objects.requireNonNull(DefaultCloudFoundryOperations.super.getUsername(), "username");
                this.usernameBuildStage = 1;
            }
            return this.username;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.advancedBuildStage == -1) {
                attributes.add("advanced");
            }
            if (this.applicationsBuildStage == -1) {
                attributes.add("applications");
            }
            if (this.buildpacksBuildStage == -1) {
                attributes.add("buildpacks");
            }
            if (this.domainsBuildStage == -1) {
                attributes.add("domains");
            }
            if (this.networkPoliciesBuildStage == -1) {
                attributes.add("networkPolicies");
            }
            if (this.organizationAdminBuildStage == -1) {
                attributes.add("organizationAdmin");
            }
            if (this.organizationsBuildStage == -1) {
                attributes.add("organizations");
            }
            if (this.routesBuildStage == -1) {
                attributes.add("routes");
            }
            if (this.serviceAdminBuildStage == -1) {
                attributes.add("serviceAdmin");
            }
            if (this.servicesBuildStage == -1) {
                attributes.add("services");
            }
            if (this.spaceAdminBuildStage == -1) {
                attributes.add("spaceAdmin");
            }
            if (this.spacesBuildStage == -1) {
                attributes.add("spaces");
            }
            if (this.stacksBuildStage == -1) {
                attributes.add("stacks");
            }
            if (this.userAdminBuildStage == -1) {
                attributes.add("userAdmin");
            }
            if (this.cloudFoundryClientPublisherBuildStage == -1) {
                attributes.add("cloudFoundryClientPublisher");
            }
            if (this.dopplerClientPublisherBuildStage == -1) {
                attributes.add("dopplerClientPublisher");
            }
            if (this.networkingClientPublisherBuildStage == -1) {
                attributes.add("networkingClientPublisher");
            }
            if (this.organizationIdBuildStage == -1) {
                attributes.add("organizationId");
            }
            if (this.routingClientPublisherBuildStage == -1) {
                attributes.add("routingClientPublisher");
            }
            if (this.spaceIdBuildStage == -1) {
                attributes.add("spaceId");
            }
            if (this.uaaClientPublisherBuildStage == -1) {
                attributes.add("uaaClientPublisher");
            }
            if (this.usernameBuildStage == -1) {
                attributes.add("username");
            }
            return "Cannot build DefaultCloudFoundryOperations, attribute initializers form cycle" + attributes;
        }
    }
}

