/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.uaa.users;

import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.uaa.IdentityZoned;
import org.cloudfoundry.uaa.PaginatedAndSortedByRequest;
import org.cloudfoundry.uaa.PaginatedAndSortedRequest;
import org.cloudfoundry.uaa.SortOrder;
import org.cloudfoundry.uaa.users._ListUsersRequest;

public final class ListUsersRequest
extends _ListUsersRequest {
    @Nullable
    private final String sortBy;
    @Nullable
    private final Integer count;
    @Nullable
    private final String filter;
    @Nullable
    private final SortOrder sortOrder;
    @Nullable
    private final Integer startIndex;
    @Nullable
    private final String identityZoneId;
    @Nullable
    private final String identityZoneSubdomain;

    private ListUsersRequest(Builder builder) {
        this.sortBy = builder.sortBy;
        this.count = builder.count;
        this.filter = builder.filter;
        this.sortOrder = builder.sortOrder;
        this.startIndex = builder.startIndex;
        this.identityZoneId = builder.identityZoneId;
        this.identityZoneSubdomain = builder.identityZoneSubdomain;
    }

    @Override
    @Nullable
    public String getSortBy() {
        return this.sortBy;
    }

    @Override
    @Nullable
    public Integer getCount() {
        return this.count;
    }

    @Override
    @Nullable
    public String getFilter() {
        return this.filter;
    }

    @Override
    @Nullable
    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    @Override
    @Nullable
    public Integer getStartIndex() {
        return this.startIndex;
    }

    @Override
    @Nullable
    public String getIdentityZoneId() {
        return this.identityZoneId;
    }

    @Override
    @Nullable
    public String getIdentityZoneSubdomain() {
        return this.identityZoneSubdomain;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ListUsersRequest && this.equalTo((ListUsersRequest)another);
    }

    private boolean equalTo(ListUsersRequest another) {
        return Objects.equals(this.sortBy, another.sortBy) && Objects.equals(this.count, another.count) && Objects.equals(this.filter, another.filter) && Objects.equals((Object)this.sortOrder, (Object)another.sortOrder) && Objects.equals(this.startIndex, another.startIndex) && Objects.equals(this.identityZoneId, another.identityZoneId) && Objects.equals(this.identityZoneSubdomain, another.identityZoneSubdomain);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.sortBy);
        h += (h << 5) + Objects.hashCode(this.count);
        h += (h << 5) + Objects.hashCode(this.filter);
        h += (h << 5) + Objects.hashCode((Object)this.sortOrder);
        h += (h << 5) + Objects.hashCode(this.startIndex);
        h += (h << 5) + Objects.hashCode(this.identityZoneId);
        h += (h << 5) + Objects.hashCode(this.identityZoneSubdomain);
        return h;
    }

    public String toString() {
        return "ListUsersRequest{sortBy=" + this.sortBy + ", count=" + this.count + ", filter=" + this.filter + ", sortOrder=" + (Object)((Object)this.sortOrder) + ", startIndex=" + this.startIndex + ", identityZoneId=" + this.identityZoneId + ", identityZoneSubdomain=" + this.identityZoneSubdomain + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String sortBy;
        private Integer count;
        private String filter;
        private SortOrder sortOrder;
        private Integer startIndex;
        private String identityZoneId;
        private String identityZoneSubdomain;

        private Builder() {
        }

        public final Builder from(PaginatedAndSortedByRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(IdentityZoned instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(PaginatedAndSortedRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ListUsersRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        final Builder from(_ListUsersRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            String sortByValue;
            if (object instanceof PaginatedAndSortedByRequest && (sortByValue = ((PaginatedAndSortedByRequest)(instance = (PaginatedAndSortedByRequest)object)).getSortBy()) != null) {
                this.sortBy(sortByValue);
            }
            if (object instanceof IdentityZoned) {
                String identityZoneIdValue;
                instance = (IdentityZoned)object;
                String identityZoneSubdomainValue = instance.getIdentityZoneSubdomain();
                if (identityZoneSubdomainValue != null) {
                    this.identityZoneSubdomain(identityZoneSubdomainValue);
                }
                if ((identityZoneIdValue = instance.getIdentityZoneId()) != null) {
                    this.identityZoneId(identityZoneIdValue);
                }
            }
            if (object instanceof PaginatedAndSortedRequest) {
                SortOrder sortOrderValue;
                Integer startIndexValue;
                Integer countValue;
                instance = (PaginatedAndSortedRequest)object;
                String filterValue = ((PaginatedAndSortedRequest)instance).getFilter();
                if (filterValue != null) {
                    this.filter(filterValue);
                }
                if ((countValue = ((PaginatedAndSortedRequest)instance).getCount()) != null) {
                    this.count(countValue);
                }
                if ((startIndexValue = ((PaginatedAndSortedRequest)instance).getStartIndex()) != null) {
                    this.startIndex(startIndexValue);
                }
                if ((sortOrderValue = ((PaginatedAndSortedRequest)instance).getSortOrder()) != null) {
                    this.sortOrder(sortOrderValue);
                }
            }
        }

        public final Builder sortBy(@Nullable String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public final Builder count(@Nullable Integer count) {
            this.count = count;
            return this;
        }

        public final Builder filter(@Nullable String filter) {
            this.filter = filter;
            return this;
        }

        public final Builder sortOrder(@Nullable SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public final Builder startIndex(@Nullable Integer startIndex) {
            this.startIndex = startIndex;
            return this;
        }

        public final Builder identityZoneId(@Nullable String identityZoneId) {
            this.identityZoneId = identityZoneId;
            return this;
        }

        public final Builder identityZoneSubdomain(@Nullable String identityZoneSubdomain) {
            this.identityZoneSubdomain = identityZoneSubdomain;
            return this;
        }

        public ListUsersRequest build() {
            return new ListUsersRequest(this);
        }
    }
}

