/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.uaa.users;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.uaa.users._Email;

public final class Email
extends _Email {
    private final Boolean primary;
    private final String value;

    private Email(Builder builder) {
        this.primary = builder.primary;
        this.value = builder.value;
    }

    @Override
    @JsonProperty(value="primary")
    public Boolean getPrimary() {
        return this.primary;
    }

    @Override
    @JsonProperty(value="value")
    public String getValue() {
        return this.value;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Email && this.equalTo((Email)another);
    }

    private boolean equalTo(Email another) {
        return this.primary.equals(another.primary) && this.value.equals(another.value);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.primary.hashCode();
        h += (h << 5) + this.value.hashCode();
        return h;
    }

    public String toString() {
        return "Email{primary=" + this.primary + ", value=" + this.value + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static Email fromJson(Json json) {
        Builder builder = Email.builder();
        if (json.primary != null) {
            builder.primary(json.primary);
        }
        if (json.value != null) {
            builder.value(json.value);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PRIMARY = 1L;
        private static final long INIT_BIT_VALUE = 2L;
        private long initBits = 3L;
        private Boolean primary;
        private String value;

        private Builder() {
        }

        public final Builder from(Email instance) {
            return this.from((_Email)instance);
        }

        final Builder from(_Email instance) {
            Objects.requireNonNull(instance, "instance");
            this.primary(instance.getPrimary());
            this.value(instance.getValue());
            return this;
        }

        @JsonProperty(value="primary")
        public final Builder primary(Boolean primary) {
            this.primary = Objects.requireNonNull(primary, "primary");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="value")
        public final Builder value(String value) {
            this.value = Objects.requireNonNull(value, "value");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public Email build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new Email(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("primary");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("value");
            }
            return "Cannot build Email, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends _Email {
        Boolean primary;
        String value;

        Json() {
        }

        @JsonProperty(value="primary")
        public void setPrimary(Boolean primary) {
            this.primary = primary;
        }

        @JsonProperty(value="value")
        public void setValue(String value) {
            this.value = value;
        }

        @Override
        public Boolean getPrimary() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getValue() {
            throw new UnsupportedOperationException();
        }
    }
}

