/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.uaa.tokens;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.uaa.tokens.AbstractTokenKey;
import org.cloudfoundry.uaa.tokens.KeyType;
import org.cloudfoundry.uaa.tokens._GetTokenKeyResponse;

public final class GetTokenKeyResponse
extends _GetTokenKeyResponse {
    private final String algorithm;
    private final String e;
    @Nullable
    private final String id;
    private final KeyType keyType;
    private final String n;
    private final String use;
    private final String value;

    private GetTokenKeyResponse(Builder builder) {
        this.algorithm = builder.algorithm;
        this.e = builder.e;
        this.id = builder.id;
        this.keyType = builder.keyType;
        this.n = builder.n;
        this.use = builder.use;
        this.value = builder.value;
    }

    @Override
    @JsonProperty(value="alg")
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    @JsonProperty(value="e")
    public String getE() {
        return this.e;
    }

    @Override
    @JsonProperty(value="kid")
    @Nullable
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="kty")
    public KeyType getKeyType() {
        return this.keyType;
    }

    @Override
    @JsonProperty(value="n")
    public String getN() {
        return this.n;
    }

    @Override
    @JsonProperty(value="use")
    public String getUse() {
        return this.use;
    }

    @Override
    @JsonProperty(value="value")
    public String getValue() {
        return this.value;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof GetTokenKeyResponse && this.equalTo((GetTokenKeyResponse)another);
    }

    private boolean equalTo(GetTokenKeyResponse another) {
        return this.algorithm.equals(another.algorithm) && this.e.equals(another.e) && Objects.equals(this.id, another.id) && this.keyType.equals((Object)another.keyType) && this.n.equals(another.n) && this.use.equals(another.use) && this.value.equals(another.value);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.algorithm.hashCode();
        h += (h << 5) + this.e.hashCode();
        h += (h << 5) + Objects.hashCode(this.id);
        h += (h << 5) + this.keyType.hashCode();
        h += (h << 5) + this.n.hashCode();
        h += (h << 5) + this.use.hashCode();
        h += (h << 5) + this.value.hashCode();
        return h;
    }

    public String toString() {
        return "GetTokenKeyResponse{algorithm=" + this.algorithm + ", e=" + this.e + ", id=" + this.id + ", keyType=" + (Object)((Object)this.keyType) + ", n=" + this.n + ", use=" + this.use + ", value=" + this.value + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static GetTokenKeyResponse fromJson(Json json) {
        Builder builder = GetTokenKeyResponse.builder();
        if (json.algorithm != null) {
            builder.algorithm(json.algorithm);
        }
        if (json.e != null) {
            builder.e(json.e);
        }
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.keyType != null) {
            builder.keyType(json.keyType);
        }
        if (json.n != null) {
            builder.n(json.n);
        }
        if (json.use != null) {
            builder.use(json.use);
        }
        if (json.value != null) {
            builder.value(json.value);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ALGORITHM = 1L;
        private static final long INIT_BIT_E = 2L;
        private static final long INIT_BIT_KEY_TYPE = 4L;
        private static final long INIT_BIT_N = 8L;
        private static final long INIT_BIT_USE = 16L;
        private static final long INIT_BIT_VALUE = 32L;
        private long initBits = 63L;
        private String algorithm;
        private String e;
        private String id;
        private KeyType keyType;
        private String n;
        private String use;
        private String value;

        private Builder() {
        }

        public final Builder from(AbstractTokenKey instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(GetTokenKeyResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        final Builder from(_GetTokenKeyResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            if (object instanceof AbstractTokenKey) {
                AbstractTokenKey instance = (AbstractTokenKey)object;
                this.e(instance.getE());
                this.use(instance.getUse());
                String idValue = instance.getId();
                if (idValue != null) {
                    this.id(idValue);
                }
                this.keyType(instance.getKeyType());
                this.value(instance.getValue());
                this.n(instance.getN());
                this.algorithm(instance.getAlgorithm());
            }
        }

        @JsonProperty(value="alg")
        public final Builder algorithm(String algorithm) {
            this.algorithm = Objects.requireNonNull(algorithm, "algorithm");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="e")
        public final Builder e(String e) {
            this.e = Objects.requireNonNull(e, "e");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="kid")
        public final Builder id(@Nullable String id) {
            this.id = id;
            return this;
        }

        @JsonProperty(value="kty")
        public final Builder keyType(KeyType keyType) {
            this.keyType = Objects.requireNonNull(keyType, "keyType");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="n")
        public final Builder n(String n) {
            this.n = Objects.requireNonNull(n, "n");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="use")
        public final Builder use(String use) {
            this.use = Objects.requireNonNull(use, "use");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @JsonProperty(value="value")
        public final Builder value(String value) {
            this.value = Objects.requireNonNull(value, "value");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public GetTokenKeyResponse build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new GetTokenKeyResponse(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("algorithm");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("e");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("keyType");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("n");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("use");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("value");
            }
            return "Cannot build GetTokenKeyResponse, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends _GetTokenKeyResponse {
        String algorithm;
        String e;
        String id;
        KeyType keyType;
        String n;
        String use;
        String value;

        Json() {
        }

        @JsonProperty(value="alg")
        public void setAlgorithm(String algorithm) {
            this.algorithm = algorithm;
        }

        @JsonProperty(value="e")
        public void setE(String e) {
            this.e = e;
        }

        @JsonProperty(value="kid")
        public void setId(@Nullable String id) {
            this.id = id;
        }

        @JsonProperty(value="kty")
        public void setKeyType(KeyType keyType) {
            this.keyType = keyType;
        }

        @JsonProperty(value="n")
        public void setN(String n) {
            this.n = n;
        }

        @JsonProperty(value="use")
        public void setUse(String use) {
            this.use = use;
        }

        @JsonProperty(value="value")
        public void setValue(String value) {
            this.value = value;
        }

        @Override
        public String getAlgorithm() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getE() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public KeyType getKeyType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getN() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getUse() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getValue() {
            throw new UnsupportedOperationException();
        }
    }
}

