/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.uaa.identityzones;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.uaa.identityzones._UserConfig;

public final class UserConfig
extends _UserConfig {
    private final List<String> defaultGroups;

    private UserConfig(Builder builder) {
        this.defaultGroups = UserConfig.createUnmodifiableList(true, builder.defaultGroups);
    }

    @Override
    @JsonProperty(value="defaultGroups")
    public List<String> getDefaultGroups() {
        return this.defaultGroups;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof UserConfig && this.equalTo((UserConfig)another);
    }

    private boolean equalTo(UserConfig another) {
        return this.defaultGroups.equals(another.defaultGroups);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.defaultGroups.hashCode();
        return h;
    }

    public String toString() {
        return "UserConfig{defaultGroups=" + this.defaultGroups + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static UserConfig fromJson(Json json) {
        Builder builder = UserConfig.builder();
        if (json.defaultGroups != null) {
            builder.addAllDefaultGroups(json.defaultGroups);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private List<String> defaultGroups = new ArrayList<String>();

        private Builder() {
        }

        public final Builder from(UserConfig instance) {
            return this.from((_UserConfig)instance);
        }

        final Builder from(_UserConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllDefaultGroups(instance.getDefaultGroups());
            return this;
        }

        public final Builder defaultGroup(String element) {
            this.defaultGroups.add(Objects.requireNonNull(element, "defaultGroups element"));
            return this;
        }

        public final Builder defaultGroup(String ... elements) {
            for (String element : elements) {
                this.defaultGroups.add(Objects.requireNonNull(element, "defaultGroups element"));
            }
            return this;
        }

        @JsonProperty(value="defaultGroups")
        public final Builder defaultGroups(Iterable<String> elements) {
            this.defaultGroups.clear();
            return this.addAllDefaultGroups(elements);
        }

        public final Builder addAllDefaultGroups(Iterable<String> elements) {
            for (String element : elements) {
                this.defaultGroups.add(Objects.requireNonNull(element, "defaultGroups element"));
            }
            return this;
        }

        public UserConfig build() {
            return new UserConfig(this);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends _UserConfig {
        List<String> defaultGroups = Collections.emptyList();

        Json() {
        }

        @JsonProperty(value="defaultGroups")
        public void setDefaultGroups(List<String> defaultGroups) {
            this.defaultGroups = defaultGroups;
        }

        @Override
        public List<String> getDefaultGroups() {
            throw new UnsupportedOperationException();
        }
    }
}

