/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.routing.v1.tcproutes;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.routing.v1.ModificationTag;
import org.cloudfoundry.routing.v1.tcproutes.AbstractTcpRoute;
import org.cloudfoundry.routing.v1.tcproutes.EventType;
import org.cloudfoundry.routing.v1.tcproutes._TcpRouteEvent;

public final class TcpRouteEvent
extends _TcpRouteEvent {
    private final EventType eventType;
    private final String backendIp;
    private final Integer backendPort;
    @Nullable
    private final String isolationSegment;
    private final ModificationTag modificationTag;
    private final Integer port;
    private final String routerGroupId;
    private final Integer ttl;

    private TcpRouteEvent(Builder builder) {
        this.eventType = builder.eventType;
        this.backendIp = builder.backendIp;
        this.backendPort = builder.backendPort;
        this.isolationSegment = builder.isolationSegment;
        this.modificationTag = builder.modificationTag;
        this.port = builder.port;
        this.routerGroupId = builder.routerGroupId;
        this.ttl = builder.ttl;
    }

    @Override
    @JsonProperty(value="eventType")
    public EventType getEventType() {
        return this.eventType;
    }

    @Override
    @JsonProperty(value="backend_ip")
    public String getBackendIp() {
        return this.backendIp;
    }

    @Override
    @JsonProperty(value="backend_port")
    public Integer getBackendPort() {
        return this.backendPort;
    }

    @Override
    @JsonProperty(value="isolation_segment")
    @Nullable
    public String getIsolationSegment() {
        return this.isolationSegment;
    }

    @Override
    @JsonProperty(value="modification_tag")
    public ModificationTag getModificationTag() {
        return this.modificationTag;
    }

    @Override
    @JsonProperty(value="port")
    public Integer getPort() {
        return this.port;
    }

    @Override
    @JsonProperty(value="router_group_guid")
    public String getRouterGroupId() {
        return this.routerGroupId;
    }

    @Override
    @JsonProperty(value="ttl")
    public Integer getTtl() {
        return this.ttl;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof TcpRouteEvent && this.equalTo((TcpRouteEvent)another);
    }

    private boolean equalTo(TcpRouteEvent another) {
        return this.eventType.equals((Object)another.eventType) && this.backendIp.equals(another.backendIp) && this.backendPort.equals(another.backendPort) && Objects.equals(this.isolationSegment, another.isolationSegment) && this.modificationTag.equals(another.modificationTag) && this.port.equals(another.port) && this.routerGroupId.equals(another.routerGroupId) && this.ttl.equals(another.ttl);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.eventType.hashCode();
        h += (h << 5) + this.backendIp.hashCode();
        h += (h << 5) + this.backendPort.hashCode();
        h += (h << 5) + Objects.hashCode(this.isolationSegment);
        h += (h << 5) + this.modificationTag.hashCode();
        h += (h << 5) + this.port.hashCode();
        h += (h << 5) + this.routerGroupId.hashCode();
        h += (h << 5) + this.ttl.hashCode();
        return h;
    }

    public String toString() {
        return "TcpRouteEvent{eventType=" + (Object)((Object)this.eventType) + ", backendIp=" + this.backendIp + ", backendPort=" + this.backendPort + ", isolationSegment=" + this.isolationSegment + ", modificationTag=" + this.modificationTag + ", port=" + this.port + ", routerGroupId=" + this.routerGroupId + ", ttl=" + this.ttl + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static TcpRouteEvent fromJson(Json json) {
        Builder builder = TcpRouteEvent.builder();
        if (json.eventType != null) {
            builder.eventType(json.eventType);
        }
        if (json.backendIp != null) {
            builder.backendIp(json.backendIp);
        }
        if (json.backendPort != null) {
            builder.backendPort(json.backendPort);
        }
        if (json.isolationSegment != null) {
            builder.isolationSegment(json.isolationSegment);
        }
        if (json.modificationTag != null) {
            builder.modificationTag(json.modificationTag);
        }
        if (json.port != null) {
            builder.port(json.port);
        }
        if (json.routerGroupId != null) {
            builder.routerGroupId(json.routerGroupId);
        }
        if (json.ttl != null) {
            builder.ttl(json.ttl);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_EVENT_TYPE = 1L;
        private static final long INIT_BIT_BACKEND_IP = 2L;
        private static final long INIT_BIT_BACKEND_PORT = 4L;
        private static final long INIT_BIT_MODIFICATION_TAG = 8L;
        private static final long INIT_BIT_PORT = 16L;
        private static final long INIT_BIT_ROUTER_GROUP_ID = 32L;
        private static final long INIT_BIT_TTL = 64L;
        private long initBits = 127L;
        private EventType eventType;
        private String backendIp;
        private Integer backendPort;
        private String isolationSegment;
        private ModificationTag modificationTag;
        private Integer port;
        private String routerGroupId;
        private Integer ttl;

        private Builder() {
        }

        public final Builder from(TcpRouteEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        final Builder from(_TcpRouteEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AbstractTcpRoute instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            AbstractTcpRoute instance;
            if (object instanceof _TcpRouteEvent) {
                instance = (_TcpRouteEvent)object;
                this.eventType(((_TcpRouteEvent)instance).getEventType());
            }
            if (object instanceof AbstractTcpRoute) {
                instance = (AbstractTcpRoute)object;
                this.backendPort(instance.getBackendPort());
                String isolationSegmentValue = instance.getIsolationSegment();
                if (isolationSegmentValue != null) {
                    this.isolationSegment(isolationSegmentValue);
                }
                this.port(instance.getPort());
                this.modificationTag(instance.getModificationTag());
                this.routerGroupId(instance.getRouterGroupId());
                this.backendIp(instance.getBackendIp());
                this.ttl(instance.getTtl());
            }
        }

        @JsonProperty(value="eventType")
        public final Builder eventType(EventType eventType) {
            this.eventType = Objects.requireNonNull(eventType, "eventType");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="backend_ip")
        public final Builder backendIp(String backendIp) {
            this.backendIp = Objects.requireNonNull(backendIp, "backendIp");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="backend_port")
        public final Builder backendPort(Integer backendPort) {
            this.backendPort = Objects.requireNonNull(backendPort, "backendPort");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="isolation_segment")
        public final Builder isolationSegment(@Nullable String isolationSegment) {
            this.isolationSegment = isolationSegment;
            return this;
        }

        @JsonProperty(value="modification_tag")
        public final Builder modificationTag(ModificationTag modificationTag) {
            this.modificationTag = Objects.requireNonNull(modificationTag, "modificationTag");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="port")
        public final Builder port(Integer port) {
            this.port = Objects.requireNonNull(port, "port");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @JsonProperty(value="router_group_guid")
        public final Builder routerGroupId(String routerGroupId) {
            this.routerGroupId = Objects.requireNonNull(routerGroupId, "routerGroupId");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @JsonProperty(value="ttl")
        public final Builder ttl(Integer ttl) {
            this.ttl = Objects.requireNonNull(ttl, "ttl");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        public TcpRouteEvent build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new TcpRouteEvent(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("eventType");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("backendIp");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("backendPort");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("modificationTag");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("port");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("routerGroupId");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("ttl");
            }
            return "Cannot build TcpRouteEvent, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends _TcpRouteEvent {
        EventType eventType;
        String backendIp;
        Integer backendPort;
        String isolationSegment;
        ModificationTag modificationTag;
        Integer port;
        String routerGroupId;
        Integer ttl;

        Json() {
        }

        @JsonProperty(value="eventType")
        public void setEventType(EventType eventType) {
            this.eventType = eventType;
        }

        @JsonProperty(value="backend_ip")
        public void setBackendIp(String backendIp) {
            this.backendIp = backendIp;
        }

        @JsonProperty(value="backend_port")
        public void setBackendPort(Integer backendPort) {
            this.backendPort = backendPort;
        }

        @JsonProperty(value="isolation_segment")
        public void setIsolationSegment(@Nullable String isolationSegment) {
            this.isolationSegment = isolationSegment;
        }

        @JsonProperty(value="modification_tag")
        public void setModificationTag(ModificationTag modificationTag) {
            this.modificationTag = modificationTag;
        }

        @JsonProperty(value="port")
        public void setPort(Integer port) {
            this.port = port;
        }

        @JsonProperty(value="router_group_guid")
        public void setRouterGroupId(String routerGroupId) {
            this.routerGroupId = routerGroupId;
        }

        @JsonProperty(value="ttl")
        public void setTtl(Integer ttl) {
            this.ttl = ttl;
        }

        @Override
        public EventType getEventType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getBackendIp() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getBackendPort() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getIsolationSegment() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ModificationTag getModificationTag() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getPort() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getRouterGroupId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getTtl() {
            throw new UnsupportedOperationException();
        }
    }
}

