/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.networking.v1.policies;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.networking.v1.policies.Destination;
import org.cloudfoundry.networking.v1.policies.Source;
import org.cloudfoundry.networking.v1.policies._Policy;

public final class Policy
extends _Policy {
    private final Destination destination;
    private final Source source;

    private Policy(Builder builder) {
        this.destination = builder.destination;
        this.source = builder.source;
    }

    @Override
    @JsonProperty(value="destination")
    public Destination getDestination() {
        return this.destination;
    }

    @Override
    @JsonProperty(value="source")
    public Source getSource() {
        return this.source;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Policy && this.equalTo((Policy)another);
    }

    private boolean equalTo(Policy another) {
        return this.destination.equals(another.destination) && this.source.equals(another.source);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.destination.hashCode();
        h += (h << 5) + this.source.hashCode();
        return h;
    }

    public String toString() {
        return "Policy{destination=" + this.destination + ", source=" + this.source + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static Policy fromJson(Json json) {
        Builder builder = Policy.builder();
        if (json.destination != null) {
            builder.destination(json.destination);
        }
        if (json.source != null) {
            builder.source(json.source);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_DESTINATION = 1L;
        private static final long INIT_BIT_SOURCE = 2L;
        private long initBits = 3L;
        private Destination destination;
        private Source source;

        private Builder() {
        }

        public final Builder from(Policy instance) {
            return this.from((_Policy)instance);
        }

        final Builder from(_Policy instance) {
            Objects.requireNonNull(instance, "instance");
            this.destination(instance.getDestination());
            this.source(instance.getSource());
            return this;
        }

        @JsonProperty(value="destination")
        public final Builder destination(Destination destination) {
            this.destination = Objects.requireNonNull(destination, "destination");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="source")
        public final Builder source(Source source) {
            this.source = Objects.requireNonNull(source, "source");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public Policy build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new Policy(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("destination");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("source");
            }
            return "Cannot build Policy, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends _Policy {
        Destination destination;
        Source source;

        Json() {
        }

        @JsonProperty(value="destination")
        public void setDestination(Destination destination) {
            this.destination = destination;
        }

        @JsonProperty(value="source")
        public void setSource(Source source) {
            this.source = source;
        }

        @Override
        public Destination getDestination() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Source getSource() {
            throw new UnsupportedOperationException();
        }
    }
}

