/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.servicebindings;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.servicebindings._ServiceBindingData;

public final class ServiceBindingData
extends _ServiceBindingData {
    @Nullable
    private final Map<String, Object> credentials;
    @Nullable
    private final String syslogDrainUrl;
    @Nullable
    private final List<String> volumeMounts;

    private ServiceBindingData(Builder builder) {
        this.credentials = builder.credentials == null ? null : ServiceBindingData.createUnmodifiableMap(false, false, builder.credentials);
        this.syslogDrainUrl = builder.syslogDrainUrl;
        this.volumeMounts = builder.volumeMounts == null ? null : ServiceBindingData.createUnmodifiableList(true, builder.volumeMounts);
    }

    @Override
    @JsonProperty(value="credentials")
    @Nullable
    public Map<String, Object> getCredentials() {
        return this.credentials;
    }

    @Override
    @JsonProperty(value="syslog_drain_url")
    @Nullable
    public String getSyslogDrainUrl() {
        return this.syslogDrainUrl;
    }

    @Override
    @JsonProperty(value="volume_mounts")
    @Nullable
    public List<String> getVolumeMounts() {
        return this.volumeMounts;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ServiceBindingData && this.equalTo((ServiceBindingData)another);
    }

    private boolean equalTo(ServiceBindingData another) {
        return Objects.equals(this.credentials, another.credentials) && Objects.equals(this.syslogDrainUrl, another.syslogDrainUrl) && Objects.equals(this.volumeMounts, another.volumeMounts);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.credentials);
        h += (h << 5) + Objects.hashCode(this.syslogDrainUrl);
        h += (h << 5) + Objects.hashCode(this.volumeMounts);
        return h;
    }

    public String toString() {
        return "ServiceBindingData{credentials=" + this.credentials + ", syslogDrainUrl=" + this.syslogDrainUrl + ", volumeMounts=" + this.volumeMounts + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ServiceBindingData fromJson(Json json) {
        Builder builder = ServiceBindingData.builder();
        if (json.credentials != null) {
            builder.putAllCredentials(json.credentials);
        }
        if (json.syslogDrainUrl != null) {
            builder.syslogDrainUrl(json.syslogDrainUrl);
        }
        if (json.volumeMounts != null) {
            builder.addAllVolumeMounts(json.volumeMounts);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    public static final class Builder {
        private Map<String, Object> credentials = null;
        private String syslogDrainUrl;
        private List<String> volumeMounts = null;

        private Builder() {
        }

        public final Builder from(ServiceBindingData instance) {
            return this.from((_ServiceBindingData)instance);
        }

        final Builder from(_ServiceBindingData instance) {
            List<String> volumeMountsValue;
            String syslogDrainUrlValue;
            Objects.requireNonNull(instance, "instance");
            Map<String, Object> credentialsValue = instance.getCredentials();
            if (credentialsValue != null) {
                this.putAllCredentials(credentialsValue);
            }
            if ((syslogDrainUrlValue = instance.getSyslogDrainUrl()) != null) {
                this.syslogDrainUrl(syslogDrainUrlValue);
            }
            if ((volumeMountsValue = instance.getVolumeMounts()) != null) {
                this.addAllVolumeMounts(volumeMountsValue);
            }
            return this;
        }

        public final Builder credential(String key, Object value) {
            if (this.credentials == null) {
                this.credentials = new LinkedHashMap<String, Object>();
            }
            this.credentials.put(key, value);
            return this;
        }

        public final Builder credential(Map.Entry<String, ? extends Object> entry) {
            if (this.credentials == null) {
                this.credentials = new LinkedHashMap<String, Object>();
            }
            String k = entry.getKey();
            Object v = entry.getValue();
            this.credentials.put(k, v);
            return this;
        }

        @JsonProperty(value="credentials")
        public final Builder credentials(@Nullable Map<String, ? extends Object> credentials) {
            if (credentials == null) {
                this.credentials = null;
                return this;
            }
            this.credentials = new LinkedHashMap<String, Object>();
            return this.putAllCredentials(credentials);
        }

        public final Builder putAllCredentials(Map<String, ? extends Object> credentials) {
            if (this.credentials == null) {
                this.credentials = new LinkedHashMap<String, Object>();
            }
            for (Map.Entry<String, ? extends Object> entry : credentials.entrySet()) {
                String k = entry.getKey();
                Object v = entry.getValue();
                this.credentials.put(k, v);
            }
            return this;
        }

        @JsonProperty(value="syslog_drain_url")
        public final Builder syslogDrainUrl(@Nullable String syslogDrainUrl) {
            this.syslogDrainUrl = syslogDrainUrl;
            return this;
        }

        public final Builder volumeMount(String element) {
            if (this.volumeMounts == null) {
                this.volumeMounts = new ArrayList<String>();
            }
            this.volumeMounts.add(Objects.requireNonNull(element, "volumeMounts element"));
            return this;
        }

        public final Builder volumeMount(String ... elements) {
            if (this.volumeMounts == null) {
                this.volumeMounts = new ArrayList<String>();
            }
            for (String element : elements) {
                this.volumeMounts.add(Objects.requireNonNull(element, "volumeMounts element"));
            }
            return this;
        }

        @JsonProperty(value="volume_mounts")
        public final Builder volumeMounts(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.volumeMounts = null;
                return this;
            }
            this.volumeMounts = new ArrayList<String>();
            return this.addAllVolumeMounts(elements);
        }

        public final Builder addAllVolumeMounts(Iterable<String> elements) {
            Objects.requireNonNull(elements, "volumeMounts element");
            if (this.volumeMounts == null) {
                this.volumeMounts = new ArrayList<String>();
            }
            for (String element : elements) {
                this.volumeMounts.add(Objects.requireNonNull(element, "volumeMounts element"));
            }
            return this;
        }

        public ServiceBindingData build() {
            return new ServiceBindingData(this);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends _ServiceBindingData {
        Map<String, Object> credentials = null;
        String syslogDrainUrl;
        List<String> volumeMounts = null;

        Json() {
        }

        @JsonProperty(value="credentials")
        public void setCredentials(@Nullable Map<String, Object> credentials) {
            this.credentials = credentials;
        }

        @JsonProperty(value="syslog_drain_url")
        public void setSyslogDrainUrl(@Nullable String syslogDrainUrl) {
            this.syslogDrainUrl = syslogDrainUrl;
        }

        @JsonProperty(value="volume_mounts")
        public void setVolumeMounts(@Nullable List<String> volumeMounts) {
            this.volumeMounts = volumeMounts;
        }

        @Override
        public Map<String, Object> getCredentials() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getSyslogDrainUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getVolumeMounts() {
            throw new UnsupportedOperationException();
        }
    }
}

