/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.processes;

import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.processes.HealthCheck;
import org.cloudfoundry.client.v3.processes._UpdateProcessRequest;

public final class UpdateProcessRequest
extends _UpdateProcessRequest {
    @Nullable
    private final String command;
    @Nullable
    private final HealthCheck healthCheck;
    private final String processId;

    private UpdateProcessRequest(Builder builder) {
        this.command = builder.command;
        this.healthCheck = builder.healthCheck;
        this.processId = builder.processId;
    }

    @Override
    @Nullable
    public String getCommand() {
        return this.command;
    }

    @Override
    @Nullable
    public HealthCheck getHealthCheck() {
        return this.healthCheck;
    }

    @Override
    public String getProcessId() {
        return this.processId;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof UpdateProcessRequest && this.equalTo((UpdateProcessRequest)another);
    }

    private boolean equalTo(UpdateProcessRequest another) {
        return Objects.equals(this.command, another.command) && Objects.equals(this.healthCheck, another.healthCheck) && this.processId.equals(another.processId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.command);
        h += (h << 5) + Objects.hashCode(this.healthCheck);
        h += (h << 5) + this.processId.hashCode();
        return h;
    }

    public String toString() {
        return "UpdateProcessRequest{command=" + this.command + ", healthCheck=" + this.healthCheck + ", processId=" + this.processId + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PROCESS_ID = 1L;
        private long initBits = 1L;
        private String command;
        private HealthCheck healthCheck;
        private String processId;

        private Builder() {
        }

        public final Builder from(UpdateProcessRequest instance) {
            return this.from((_UpdateProcessRequest)instance);
        }

        final Builder from(_UpdateProcessRequest instance) {
            HealthCheck healthCheckValue;
            Objects.requireNonNull(instance, "instance");
            String commandValue = instance.getCommand();
            if (commandValue != null) {
                this.command(commandValue);
            }
            if ((healthCheckValue = instance.getHealthCheck()) != null) {
                this.healthCheck(healthCheckValue);
            }
            this.processId(instance.getProcessId());
            return this;
        }

        public final Builder command(@Nullable String command) {
            this.command = command;
            return this;
        }

        public final Builder healthCheck(@Nullable HealthCheck healthCheck) {
            this.healthCheck = healthCheck;
            return this;
        }

        public final Builder processId(String processId) {
            this.processId = Objects.requireNonNull(processId, "processId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public UpdateProcessRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new UpdateProcessRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("processId");
            }
            return "Cannot build UpdateProcessRequest, some of required attributes are not set " + attributes;
        }
    }
}

