/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.packages;

import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.client.v3.packages._DeletePackageRequest;

public final class DeletePackageRequest
extends _DeletePackageRequest {
    private final String packageId;

    private DeletePackageRequest(Builder builder) {
        this.packageId = builder.packageId;
    }

    @Override
    public String getPackageId() {
        return this.packageId;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof DeletePackageRequest && this.equalTo((DeletePackageRequest)another);
    }

    private boolean equalTo(DeletePackageRequest another) {
        return this.packageId.equals(another.packageId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.packageId.hashCode();
        return h;
    }

    public String toString() {
        return "DeletePackageRequest{packageId=" + this.packageId + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PACKAGE_ID = 1L;
        private long initBits = 1L;
        private String packageId;

        private Builder() {
        }

        public final Builder from(DeletePackageRequest instance) {
            return this.from((_DeletePackageRequest)instance);
        }

        final Builder from(_DeletePackageRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.packageId(instance.getPackageId());
            return this;
        }

        public final Builder packageId(String packageId) {
            this.packageId = Objects.requireNonNull(packageId, "packageId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public DeletePackageRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new DeletePackageRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("packageId");
            }
            return "Cannot build DeletePackageRequest, some of required attributes are not set " + attributes;
        }
    }
}

