/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.droplets;

import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.client.v3.droplets.DropletRelationships;
import org.cloudfoundry.client.v3.droplets._CopyDropletRequest;

public final class CopyDropletRequest
extends _CopyDropletRequest {
    private final DropletRelationships relationships;
    private final String sourceDropletId;

    private CopyDropletRequest(Builder builder) {
        this.relationships = builder.relationships;
        this.sourceDropletId = builder.sourceDropletId;
    }

    @Override
    public DropletRelationships getRelationships() {
        return this.relationships;
    }

    @Override
    public String getSourceDropletId() {
        return this.sourceDropletId;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CopyDropletRequest && this.equalTo((CopyDropletRequest)another);
    }

    private boolean equalTo(CopyDropletRequest another) {
        return this.relationships.equals(another.relationships) && this.sourceDropletId.equals(another.sourceDropletId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.relationships.hashCode();
        h += (h << 5) + this.sourceDropletId.hashCode();
        return h;
    }

    public String toString() {
        return "CopyDropletRequest{relationships=" + this.relationships + ", sourceDropletId=" + this.sourceDropletId + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_RELATIONSHIPS = 1L;
        private static final long INIT_BIT_SOURCE_DROPLET_ID = 2L;
        private long initBits = 3L;
        private DropletRelationships relationships;
        private String sourceDropletId;

        private Builder() {
        }

        public final Builder from(CopyDropletRequest instance) {
            return this.from((_CopyDropletRequest)instance);
        }

        final Builder from(_CopyDropletRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.relationships(instance.getRelationships());
            this.sourceDropletId(instance.getSourceDropletId());
            return this;
        }

        public final Builder relationships(DropletRelationships relationships) {
            this.relationships = Objects.requireNonNull(relationships, "relationships");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder sourceDropletId(String sourceDropletId) {
            this.sourceDropletId = Objects.requireNonNull(sourceDropletId, "sourceDropletId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public CopyDropletRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new CopyDropletRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("relationships");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("sourceDropletId");
            }
            return "Cannot build CopyDropletRequest, some of required attributes are not set " + attributes;
        }
    }
}

