/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.client.v3.Error;
import org.cloudfoundry.client.v3._Errors;

public final class Errors
extends _Errors {
    private final List<Error> errors;

    private Errors(Builder builder) {
        this.errors = Errors.createUnmodifiableList(true, builder.errors);
    }

    @Override
    @JsonProperty(value="errors")
    public List<Error> getErrors() {
        return this.errors;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Errors && this.equalTo((Errors)another);
    }

    private boolean equalTo(Errors another) {
        return this.errors.equals(another.errors);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.errors.hashCode();
        return h;
    }

    public String toString() {
        return "Errors{errors=" + this.errors + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static Errors fromJson(Json json) {
        Builder builder = Errors.builder();
        if (json.errors != null) {
            builder.addAllErrors(json.errors);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private List<Error> errors = new ArrayList<Error>();

        private Builder() {
        }

        public final Builder from(Errors instance) {
            return this.from((_Errors)instance);
        }

        final Builder from(_Errors instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllErrors(instance.getErrors());
            return this;
        }

        public final Builder error(Error element) {
            this.errors.add(Objects.requireNonNull(element, "errors element"));
            return this;
        }

        public final Builder error(Error ... elements) {
            for (Error element : elements) {
                this.errors.add(Objects.requireNonNull(element, "errors element"));
            }
            return this;
        }

        @JsonProperty(value="errors")
        public final Builder errors(Iterable<? extends Error> elements) {
            this.errors.clear();
            return this.addAllErrors(elements);
        }

        public final Builder addAllErrors(Iterable<? extends Error> elements) {
            for (Error error : elements) {
                this.errors.add(Objects.requireNonNull(error, "errors element"));
            }
            return this;
        }

        public Errors build() {
            return new Errors(this);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends _Errors {
        List<Error> errors = Collections.emptyList();

        Json() {
        }

        @JsonProperty(value="errors")
        public void setErrors(List<Error> errors) {
            this.errors = errors;
        }

        @Override
        public List<Error> getErrors() {
            throw new UnsupportedOperationException();
        }
    }
}

