/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.serviceplanvisibilities;

import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.client.v2.serviceplanvisibilities._CreateServicePlanVisibilityRequest;

public final class CreateServicePlanVisibilityRequest
extends _CreateServicePlanVisibilityRequest {
    private final String organizationId;
    private final String servicePlanId;

    private CreateServicePlanVisibilityRequest(Builder builder) {
        this.organizationId = builder.organizationId;
        this.servicePlanId = builder.servicePlanId;
    }

    @Override
    public String getOrganizationId() {
        return this.organizationId;
    }

    @Override
    public String getServicePlanId() {
        return this.servicePlanId;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CreateServicePlanVisibilityRequest && this.equalTo((CreateServicePlanVisibilityRequest)another);
    }

    private boolean equalTo(CreateServicePlanVisibilityRequest another) {
        return this.organizationId.equals(another.organizationId) && this.servicePlanId.equals(another.servicePlanId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.organizationId.hashCode();
        h += (h << 5) + this.servicePlanId.hashCode();
        return h;
    }

    public String toString() {
        return "CreateServicePlanVisibilityRequest{organizationId=" + this.organizationId + ", servicePlanId=" + this.servicePlanId + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ORGANIZATION_ID = 1L;
        private static final long INIT_BIT_SERVICE_PLAN_ID = 2L;
        private long initBits = 3L;
        private String organizationId;
        private String servicePlanId;

        private Builder() {
        }

        public final Builder from(CreateServicePlanVisibilityRequest instance) {
            return this.from((_CreateServicePlanVisibilityRequest)instance);
        }

        final Builder from(_CreateServicePlanVisibilityRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.organizationId(instance.getOrganizationId());
            this.servicePlanId(instance.getServicePlanId());
            return this;
        }

        public final Builder organizationId(String organizationId) {
            this.organizationId = Objects.requireNonNull(organizationId, "organizationId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder servicePlanId(String servicePlanId) {
            this.servicePlanId = Objects.requireNonNull(servicePlanId, "servicePlanId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public CreateServicePlanVisibilityRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new CreateServicePlanVisibilityRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("organizationId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("servicePlanId");
            }
            return "Cannot build CreateServicePlanVisibilityRequest, some of required attributes are not set " + attributes;
        }
    }
}

