/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.serviceplans;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.OrderDirection;
import org.cloudfoundry.client.v2.PaginatedRequest;
import org.cloudfoundry.client.v2.serviceplans._ListServicePlansRequest;

public final class ListServicePlansRequest
extends _ListServicePlansRequest {
    @Nullable
    private final Boolean active;
    @Nullable
    private final List<String> serviceBrokerIds;
    @Nullable
    private final List<String> serviceIds;
    @Nullable
    private final List<String> serviceInstanceIds;
    @Nullable
    private final OrderDirection orderDirection;
    @Nullable
    private final Integer page;
    @Nullable
    private final Integer resultsPerPage;

    private ListServicePlansRequest(Builder builder) {
        this.active = builder.active;
        this.serviceBrokerIds = builder.serviceBrokerIds == null ? null : ListServicePlansRequest.createUnmodifiableList(true, builder.serviceBrokerIds);
        this.serviceIds = builder.serviceIds == null ? null : ListServicePlansRequest.createUnmodifiableList(true, builder.serviceIds);
        this.serviceInstanceIds = builder.serviceInstanceIds == null ? null : ListServicePlansRequest.createUnmodifiableList(true, builder.serviceInstanceIds);
        this.orderDirection = builder.orderDirection;
        this.page = builder.page;
        this.resultsPerPage = builder.resultsPerPage;
    }

    @Override
    @Nullable
    public Boolean getActive() {
        return this.active;
    }

    @Override
    @Nullable
    public List<String> getServiceBrokerIds() {
        return this.serviceBrokerIds;
    }

    @Override
    @Nullable
    public List<String> getServiceIds() {
        return this.serviceIds;
    }

    @Override
    @Nullable
    public List<String> getServiceInstanceIds() {
        return this.serviceInstanceIds;
    }

    @Override
    @Nullable
    public OrderDirection getOrderDirection() {
        return this.orderDirection;
    }

    @Override
    @Nullable
    public Integer getPage() {
        return this.page;
    }

    @Override
    @Nullable
    public Integer getResultsPerPage() {
        return this.resultsPerPage;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ListServicePlansRequest && this.equalTo((ListServicePlansRequest)another);
    }

    private boolean equalTo(ListServicePlansRequest another) {
        return Objects.equals(this.active, another.active) && Objects.equals(this.serviceBrokerIds, another.serviceBrokerIds) && Objects.equals(this.serviceIds, another.serviceIds) && Objects.equals(this.serviceInstanceIds, another.serviceInstanceIds) && Objects.equals((Object)this.orderDirection, (Object)another.orderDirection) && Objects.equals(this.page, another.page) && Objects.equals(this.resultsPerPage, another.resultsPerPage);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.active);
        h += (h << 5) + Objects.hashCode(this.serviceBrokerIds);
        h += (h << 5) + Objects.hashCode(this.serviceIds);
        h += (h << 5) + Objects.hashCode(this.serviceInstanceIds);
        h += (h << 5) + Objects.hashCode((Object)this.orderDirection);
        h += (h << 5) + Objects.hashCode(this.page);
        h += (h << 5) + Objects.hashCode(this.resultsPerPage);
        return h;
    }

    public String toString() {
        return "ListServicePlansRequest{active=" + this.active + ", serviceBrokerIds=" + this.serviceBrokerIds + ", serviceIds=" + this.serviceIds + ", serviceInstanceIds=" + this.serviceInstanceIds + ", orderDirection=" + (Object)((Object)this.orderDirection) + ", page=" + this.page + ", resultsPerPage=" + this.resultsPerPage + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private Boolean active;
        private List<String> serviceBrokerIds = null;
        private List<String> serviceIds = null;
        private List<String> serviceInstanceIds = null;
        private OrderDirection orderDirection;
        private Integer page;
        private Integer resultsPerPage;

        private Builder() {
        }

        public final Builder from(PaginatedRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ListServicePlansRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        final Builder from(_ListServicePlansRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            PaginatedRequest instance;
            if (object instanceof PaginatedRequest) {
                Integer pageValue;
                Integer resultsPerPageValue;
                instance = (PaginatedRequest)object;
                OrderDirection orderDirectionValue = instance.getOrderDirection();
                if (orderDirectionValue != null) {
                    this.orderDirection(orderDirectionValue);
                }
                if ((resultsPerPageValue = instance.getResultsPerPage()) != null) {
                    this.resultsPerPage(resultsPerPageValue);
                }
                if ((pageValue = instance.getPage()) != null) {
                    this.page(pageValue);
                }
            }
            if (object instanceof _ListServicePlansRequest) {
                List<String> serviceBrokerIdsValue;
                List<String> serviceInstanceIdsValue;
                List<String> serviceIdsValue;
                instance = (_ListServicePlansRequest)object;
                Boolean activeValue = ((_ListServicePlansRequest)instance).getActive();
                if (activeValue != null) {
                    this.active(activeValue);
                }
                if ((serviceIdsValue = ((_ListServicePlansRequest)instance).getServiceIds()) != null) {
                    this.addAllServiceIds(serviceIdsValue);
                }
                if ((serviceInstanceIdsValue = ((_ListServicePlansRequest)instance).getServiceInstanceIds()) != null) {
                    this.addAllServiceInstanceIds(serviceInstanceIdsValue);
                }
                if ((serviceBrokerIdsValue = ((_ListServicePlansRequest)instance).getServiceBrokerIds()) != null) {
                    this.addAllServiceBrokerIds(serviceBrokerIdsValue);
                }
            }
        }

        public final Builder active(@Nullable Boolean active) {
            this.active = active;
            return this;
        }

        public final Builder serviceBrokerId(String element) {
            if (this.serviceBrokerIds == null) {
                this.serviceBrokerIds = new ArrayList<String>();
            }
            this.serviceBrokerIds.add(Objects.requireNonNull(element, "serviceBrokerIds element"));
            return this;
        }

        public final Builder serviceBrokerId(String ... elements) {
            if (this.serviceBrokerIds == null) {
                this.serviceBrokerIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.serviceBrokerIds.add(Objects.requireNonNull(element, "serviceBrokerIds element"));
            }
            return this;
        }

        public final Builder serviceBrokerIds(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.serviceBrokerIds = null;
                return this;
            }
            this.serviceBrokerIds = new ArrayList<String>();
            return this.addAllServiceBrokerIds(elements);
        }

        public final Builder addAllServiceBrokerIds(Iterable<String> elements) {
            Objects.requireNonNull(elements, "serviceBrokerIds element");
            if (this.serviceBrokerIds == null) {
                this.serviceBrokerIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.serviceBrokerIds.add(Objects.requireNonNull(element, "serviceBrokerIds element"));
            }
            return this;
        }

        public final Builder serviceId(String element) {
            if (this.serviceIds == null) {
                this.serviceIds = new ArrayList<String>();
            }
            this.serviceIds.add(Objects.requireNonNull(element, "serviceIds element"));
            return this;
        }

        public final Builder serviceId(String ... elements) {
            if (this.serviceIds == null) {
                this.serviceIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.serviceIds.add(Objects.requireNonNull(element, "serviceIds element"));
            }
            return this;
        }

        public final Builder serviceIds(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.serviceIds = null;
                return this;
            }
            this.serviceIds = new ArrayList<String>();
            return this.addAllServiceIds(elements);
        }

        public final Builder addAllServiceIds(Iterable<String> elements) {
            Objects.requireNonNull(elements, "serviceIds element");
            if (this.serviceIds == null) {
                this.serviceIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.serviceIds.add(Objects.requireNonNull(element, "serviceIds element"));
            }
            return this;
        }

        public final Builder serviceInstanceId(String element) {
            if (this.serviceInstanceIds == null) {
                this.serviceInstanceIds = new ArrayList<String>();
            }
            this.serviceInstanceIds.add(Objects.requireNonNull(element, "serviceInstanceIds element"));
            return this;
        }

        public final Builder serviceInstanceId(String ... elements) {
            if (this.serviceInstanceIds == null) {
                this.serviceInstanceIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.serviceInstanceIds.add(Objects.requireNonNull(element, "serviceInstanceIds element"));
            }
            return this;
        }

        public final Builder serviceInstanceIds(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.serviceInstanceIds = null;
                return this;
            }
            this.serviceInstanceIds = new ArrayList<String>();
            return this.addAllServiceInstanceIds(elements);
        }

        public final Builder addAllServiceInstanceIds(Iterable<String> elements) {
            Objects.requireNonNull(elements, "serviceInstanceIds element");
            if (this.serviceInstanceIds == null) {
                this.serviceInstanceIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.serviceInstanceIds.add(Objects.requireNonNull(element, "serviceInstanceIds element"));
            }
            return this;
        }

        public final Builder orderDirection(@Nullable OrderDirection orderDirection) {
            this.orderDirection = orderDirection;
            return this;
        }

        public final Builder page(@Nullable Integer page) {
            this.page = page;
            return this;
        }

        public final Builder resultsPerPage(@Nullable Integer resultsPerPage) {
            this.resultsPerPage = resultsPerPage;
            return this;
        }

        public ListServicePlansRequest build() {
            return new ListServicePlansRequest(this);
        }
    }
}

