/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.serviceinstances;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.serviceinstances.LastOperation;
import org.cloudfoundry.client.v2.serviceinstances.Plan;
import org.cloudfoundry.client.v2.serviceinstances._ServiceInstance;

public final class ServiceInstance
extends _ServiceInstance {
    @Nullable
    private final Integer boundApplicationCount;
    @Nullable
    private final String dashboardUrl;
    @Nullable
    private final String id;
    @Nullable
    private final LastOperation lastOperation;
    @Nullable
    private final String name;
    @Nullable
    private final Plan servicePlan;

    private ServiceInstance(Builder builder) {
        this.boundApplicationCount = builder.boundApplicationCount;
        this.dashboardUrl = builder.dashboardUrl;
        this.id = builder.id;
        this.lastOperation = builder.lastOperation;
        this.name = builder.name;
        this.servicePlan = builder.servicePlan;
    }

    @Override
    @JsonProperty(value="bound_app_count")
    @Nullable
    public Integer getBoundApplicationCount() {
        return this.boundApplicationCount;
    }

    @Override
    @JsonProperty(value="dashboard_url")
    @Nullable
    public String getDashboardUrl() {
        return this.dashboardUrl;
    }

    @Override
    @JsonProperty(value="guid")
    @Nullable
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="last_operation")
    @Nullable
    public LastOperation getLastOperation() {
        return this.lastOperation;
    }

    @Override
    @JsonProperty(value="name")
    @Nullable
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="service_plan")
    @Nullable
    public Plan getServicePlan() {
        return this.servicePlan;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ServiceInstance && this.equalTo((ServiceInstance)another);
    }

    private boolean equalTo(ServiceInstance another) {
        return Objects.equals(this.boundApplicationCount, another.boundApplicationCount) && Objects.equals(this.dashboardUrl, another.dashboardUrl) && Objects.equals(this.id, another.id) && Objects.equals(this.lastOperation, another.lastOperation) && Objects.equals(this.name, another.name) && Objects.equals(this.servicePlan, another.servicePlan);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.boundApplicationCount);
        h += (h << 5) + Objects.hashCode(this.dashboardUrl);
        h += (h << 5) + Objects.hashCode(this.id);
        h += (h << 5) + Objects.hashCode(this.lastOperation);
        h += (h << 5) + Objects.hashCode(this.name);
        h += (h << 5) + Objects.hashCode(this.servicePlan);
        return h;
    }

    public String toString() {
        return "ServiceInstance{boundApplicationCount=" + this.boundApplicationCount + ", dashboardUrl=" + this.dashboardUrl + ", id=" + this.id + ", lastOperation=" + this.lastOperation + ", name=" + this.name + ", servicePlan=" + this.servicePlan + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ServiceInstance fromJson(Json json) {
        Builder builder = ServiceInstance.builder();
        if (json.boundApplicationCount != null) {
            builder.boundApplicationCount(json.boundApplicationCount);
        }
        if (json.dashboardUrl != null) {
            builder.dashboardUrl(json.dashboardUrl);
        }
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.lastOperation != null) {
            builder.lastOperation(json.lastOperation);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.servicePlan != null) {
            builder.servicePlan(json.servicePlan);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer boundApplicationCount;
        private String dashboardUrl;
        private String id;
        private LastOperation lastOperation;
        private String name;
        private Plan servicePlan;

        private Builder() {
        }

        public final Builder from(ServiceInstance instance) {
            return this.from((_ServiceInstance)instance);
        }

        final Builder from(_ServiceInstance instance) {
            Plan servicePlanValue;
            String nameValue;
            LastOperation lastOperationValue;
            String idValue;
            String dashboardUrlValue;
            Objects.requireNonNull(instance, "instance");
            Integer boundApplicationCountValue = instance.getBoundApplicationCount();
            if (boundApplicationCountValue != null) {
                this.boundApplicationCount(boundApplicationCountValue);
            }
            if ((dashboardUrlValue = instance.getDashboardUrl()) != null) {
                this.dashboardUrl(dashboardUrlValue);
            }
            if ((idValue = instance.getId()) != null) {
                this.id(idValue);
            }
            if ((lastOperationValue = instance.getLastOperation()) != null) {
                this.lastOperation(lastOperationValue);
            }
            if ((nameValue = instance.getName()) != null) {
                this.name(nameValue);
            }
            if ((servicePlanValue = instance.getServicePlan()) != null) {
                this.servicePlan(servicePlanValue);
            }
            return this;
        }

        @JsonProperty(value="bound_app_count")
        public final Builder boundApplicationCount(@Nullable Integer boundApplicationCount) {
            this.boundApplicationCount = boundApplicationCount;
            return this;
        }

        @JsonProperty(value="dashboard_url")
        public final Builder dashboardUrl(@Nullable String dashboardUrl) {
            this.dashboardUrl = dashboardUrl;
            return this;
        }

        @JsonProperty(value="guid")
        public final Builder id(@Nullable String id) {
            this.id = id;
            return this;
        }

        @JsonProperty(value="last_operation")
        public final Builder lastOperation(@Nullable LastOperation lastOperation) {
            this.lastOperation = lastOperation;
            return this;
        }

        @JsonProperty(value="name")
        public final Builder name(@Nullable String name) {
            this.name = name;
            return this;
        }

        @JsonProperty(value="service_plan")
        public final Builder servicePlan(@Nullable Plan servicePlan) {
            this.servicePlan = servicePlan;
            return this;
        }

        public ServiceInstance build() {
            return new ServiceInstance(this);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends _ServiceInstance {
        Integer boundApplicationCount;
        String dashboardUrl;
        String id;
        LastOperation lastOperation;
        String name;
        Plan servicePlan;

        Json() {
        }

        @JsonProperty(value="bound_app_count")
        public void setBoundApplicationCount(@Nullable Integer boundApplicationCount) {
            this.boundApplicationCount = boundApplicationCount;
        }

        @JsonProperty(value="dashboard_url")
        public void setDashboardUrl(@Nullable String dashboardUrl) {
            this.dashboardUrl = dashboardUrl;
        }

        @JsonProperty(value="guid")
        public void setId(@Nullable String id) {
            this.id = id;
        }

        @JsonProperty(value="last_operation")
        public void setLastOperation(@Nullable LastOperation lastOperation) {
            this.lastOperation = lastOperation;
        }

        @JsonProperty(value="name")
        public void setName(@Nullable String name) {
            this.name = name;
        }

        @JsonProperty(value="service_plan")
        public void setServicePlan(@Nullable Plan servicePlan) {
            this.servicePlan = servicePlan;
        }

        @Override
        public Integer getBoundApplicationCount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getDashboardUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public LastOperation getLastOperation() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Plan getServicePlan() {
            throw new UnsupportedOperationException();
        }
    }
}

