/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.serviceinstances;

import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.serviceinstances._DeleteServiceInstanceRequest;

public final class DeleteServiceInstanceRequest
extends _DeleteServiceInstanceRequest {
    @Nullable
    private final Boolean acceptsIncomplete;
    @Nullable
    private final Boolean async;
    @Nullable
    private final Boolean purge;
    @Nullable
    private final Boolean recursive;
    private final String serviceInstanceId;

    private DeleteServiceInstanceRequest(Builder builder) {
        this.acceptsIncomplete = builder.acceptsIncomplete;
        this.async = builder.async;
        this.purge = builder.purge;
        this.recursive = builder.recursive;
        this.serviceInstanceId = builder.serviceInstanceId;
    }

    @Override
    @Nullable
    public Boolean getAcceptsIncomplete() {
        return this.acceptsIncomplete;
    }

    @Override
    @Nullable
    public Boolean getAsync() {
        return this.async;
    }

    @Override
    @Nullable
    public Boolean getPurge() {
        return this.purge;
    }

    @Override
    @Nullable
    public Boolean getRecursive() {
        return this.recursive;
    }

    @Override
    public String getServiceInstanceId() {
        return this.serviceInstanceId;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof DeleteServiceInstanceRequest && this.equalTo((DeleteServiceInstanceRequest)another);
    }

    private boolean equalTo(DeleteServiceInstanceRequest another) {
        return Objects.equals(this.acceptsIncomplete, another.acceptsIncomplete) && Objects.equals(this.async, another.async) && Objects.equals(this.purge, another.purge) && Objects.equals(this.recursive, another.recursive) && this.serviceInstanceId.equals(another.serviceInstanceId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.acceptsIncomplete);
        h += (h << 5) + Objects.hashCode(this.async);
        h += (h << 5) + Objects.hashCode(this.purge);
        h += (h << 5) + Objects.hashCode(this.recursive);
        h += (h << 5) + this.serviceInstanceId.hashCode();
        return h;
    }

    public String toString() {
        return "DeleteServiceInstanceRequest{acceptsIncomplete=" + this.acceptsIncomplete + ", async=" + this.async + ", purge=" + this.purge + ", recursive=" + this.recursive + ", serviceInstanceId=" + this.serviceInstanceId + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_SERVICE_INSTANCE_ID = 1L;
        private long initBits = 1L;
        private Boolean acceptsIncomplete;
        private Boolean async;
        private Boolean purge;
        private Boolean recursive;
        private String serviceInstanceId;

        private Builder() {
        }

        public final Builder from(DeleteServiceInstanceRequest instance) {
            return this.from((_DeleteServiceInstanceRequest)instance);
        }

        final Builder from(_DeleteServiceInstanceRequest instance) {
            Boolean recursiveValue;
            Boolean purgeValue;
            Boolean asyncValue;
            Objects.requireNonNull(instance, "instance");
            Boolean acceptsIncompleteValue = instance.getAcceptsIncomplete();
            if (acceptsIncompleteValue != null) {
                this.acceptsIncomplete(acceptsIncompleteValue);
            }
            if ((asyncValue = instance.getAsync()) != null) {
                this.async(asyncValue);
            }
            if ((purgeValue = instance.getPurge()) != null) {
                this.purge(purgeValue);
            }
            if ((recursiveValue = instance.getRecursive()) != null) {
                this.recursive(recursiveValue);
            }
            this.serviceInstanceId(instance.getServiceInstanceId());
            return this;
        }

        public final Builder acceptsIncomplete(@Nullable Boolean acceptsIncomplete) {
            this.acceptsIncomplete = acceptsIncomplete;
            return this;
        }

        public final Builder async(@Nullable Boolean async) {
            this.async = async;
            return this;
        }

        public final Builder purge(@Nullable Boolean purge) {
            this.purge = purge;
            return this;
        }

        public final Builder recursive(@Nullable Boolean recursive) {
            this.recursive = recursive;
            return this;
        }

        public final Builder serviceInstanceId(String serviceInstanceId) {
            this.serviceInstanceId = Objects.requireNonNull(serviceInstanceId, "serviceInstanceId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public DeleteServiceInstanceRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new DeleteServiceInstanceRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("serviceInstanceId");
            }
            return "Cannot build DeleteServiceInstanceRequest, some of required attributes are not set " + attributes;
        }
    }
}

