/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.servicebrokers;

import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.servicebrokers._UpdateServiceBrokerRequest;

public final class UpdateServiceBrokerRequest
extends _UpdateServiceBrokerRequest {
    @Nullable
    private final String authenticationPassword;
    @Nullable
    private final String authenticationUsername;
    @Nullable
    private final String brokerUrl;
    @Nullable
    private final String name;
    private final String serviceBrokerId;

    private UpdateServiceBrokerRequest(Builder builder) {
        this.authenticationPassword = builder.authenticationPassword;
        this.authenticationUsername = builder.authenticationUsername;
        this.brokerUrl = builder.brokerUrl;
        this.name = builder.name;
        this.serviceBrokerId = builder.serviceBrokerId;
    }

    @Override
    @Nullable
    public String getAuthenticationPassword() {
        return this.authenticationPassword;
    }

    @Override
    @Nullable
    public String getAuthenticationUsername() {
        return this.authenticationUsername;
    }

    @Override
    @Nullable
    public String getBrokerUrl() {
        return this.brokerUrl;
    }

    @Override
    @Nullable
    public String getName() {
        return this.name;
    }

    @Override
    public String getServiceBrokerId() {
        return this.serviceBrokerId;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof UpdateServiceBrokerRequest && this.equalTo((UpdateServiceBrokerRequest)another);
    }

    private boolean equalTo(UpdateServiceBrokerRequest another) {
        return Objects.equals(this.authenticationPassword, another.authenticationPassword) && Objects.equals(this.authenticationUsername, another.authenticationUsername) && Objects.equals(this.brokerUrl, another.brokerUrl) && Objects.equals(this.name, another.name) && this.serviceBrokerId.equals(another.serviceBrokerId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.authenticationPassword);
        h += (h << 5) + Objects.hashCode(this.authenticationUsername);
        h += (h << 5) + Objects.hashCode(this.brokerUrl);
        h += (h << 5) + Objects.hashCode(this.name);
        h += (h << 5) + this.serviceBrokerId.hashCode();
        return h;
    }

    public String toString() {
        return "UpdateServiceBrokerRequest{authenticationPassword=" + this.authenticationPassword + ", authenticationUsername=" + this.authenticationUsername + ", brokerUrl=" + this.brokerUrl + ", name=" + this.name + ", serviceBrokerId=" + this.serviceBrokerId + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_SERVICE_BROKER_ID = 1L;
        private long initBits = 1L;
        private String authenticationPassword;
        private String authenticationUsername;
        private String brokerUrl;
        private String name;
        private String serviceBrokerId;

        private Builder() {
        }

        public final Builder from(UpdateServiceBrokerRequest instance) {
            return this.from((_UpdateServiceBrokerRequest)instance);
        }

        final Builder from(_UpdateServiceBrokerRequest instance) {
            String nameValue;
            String brokerUrlValue;
            String authenticationUsernameValue;
            Objects.requireNonNull(instance, "instance");
            String authenticationPasswordValue = instance.getAuthenticationPassword();
            if (authenticationPasswordValue != null) {
                this.authenticationPassword(authenticationPasswordValue);
            }
            if ((authenticationUsernameValue = instance.getAuthenticationUsername()) != null) {
                this.authenticationUsername(authenticationUsernameValue);
            }
            if ((brokerUrlValue = instance.getBrokerUrl()) != null) {
                this.brokerUrl(brokerUrlValue);
            }
            if ((nameValue = instance.getName()) != null) {
                this.name(nameValue);
            }
            this.serviceBrokerId(instance.getServiceBrokerId());
            return this;
        }

        public final Builder authenticationPassword(@Nullable String authenticationPassword) {
            this.authenticationPassword = authenticationPassword;
            return this;
        }

        public final Builder authenticationUsername(@Nullable String authenticationUsername) {
            this.authenticationUsername = authenticationUsername;
            return this;
        }

        public final Builder brokerUrl(@Nullable String brokerUrl) {
            this.brokerUrl = brokerUrl;
            return this;
        }

        public final Builder name(@Nullable String name) {
            this.name = name;
            return this;
        }

        public final Builder serviceBrokerId(String serviceBrokerId) {
            this.serviceBrokerId = Objects.requireNonNull(serviceBrokerId, "serviceBrokerId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public UpdateServiceBrokerRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new UpdateServiceBrokerRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("serviceBrokerId");
            }
            return "Cannot build UpdateServiceBrokerRequest, some of required attributes are not set " + attributes;
        }
    }
}

