/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.securitygroups;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.securitygroups.RuleEntity;
import org.cloudfoundry.client.v2.securitygroups._CreateSecurityGroupRequest;

public final class CreateSecurityGroupRequest
extends _CreateSecurityGroupRequest {
    private final String name;
    @Nullable
    private final List<RuleEntity> rules;
    @Nullable
    private final List<String> spaceIds;

    private CreateSecurityGroupRequest(Builder builder) {
        this.name = builder.name;
        this.rules = builder.rules == null ? null : CreateSecurityGroupRequest.createUnmodifiableList(true, builder.rules);
        this.spaceIds = builder.spaceIds == null ? null : CreateSecurityGroupRequest.createUnmodifiableList(true, builder.spaceIds);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public List<RuleEntity> getRules() {
        return this.rules;
    }

    @Override
    @Nullable
    public List<String> getSpaceIds() {
        return this.spaceIds;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CreateSecurityGroupRequest && this.equalTo((CreateSecurityGroupRequest)another);
    }

    private boolean equalTo(CreateSecurityGroupRequest another) {
        return this.name.equals(another.name) && Objects.equals(this.rules, another.rules) && Objects.equals(this.spaceIds, another.spaceIds);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + Objects.hashCode(this.rules);
        h += (h << 5) + Objects.hashCode(this.spaceIds);
        return h;
    }

    public String toString() {
        return "CreateSecurityGroupRequest{name=" + this.name + ", rules=" + this.rules + ", spaceIds=" + this.spaceIds + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private long initBits = 1L;
        private String name;
        private List<RuleEntity> rules = null;
        private List<String> spaceIds = null;

        private Builder() {
        }

        public final Builder from(CreateSecurityGroupRequest instance) {
            return this.from((_CreateSecurityGroupRequest)instance);
        }

        final Builder from(_CreateSecurityGroupRequest instance) {
            List<String> spaceIdsValue;
            Objects.requireNonNull(instance, "instance");
            this.name(instance.getName());
            List<RuleEntity> rulesValue = instance.getRules();
            if (rulesValue != null) {
                this.addAllRules(rulesValue);
            }
            if ((spaceIdsValue = instance.getSpaceIds()) != null) {
                this.addAllSpaceIds(spaceIdsValue);
            }
            return this;
        }

        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder rule(RuleEntity element) {
            if (this.rules == null) {
                this.rules = new ArrayList<RuleEntity>();
            }
            this.rules.add(Objects.requireNonNull(element, "rules element"));
            return this;
        }

        public final Builder rule(RuleEntity ... elements) {
            if (this.rules == null) {
                this.rules = new ArrayList<RuleEntity>();
            }
            for (RuleEntity element : elements) {
                this.rules.add(Objects.requireNonNull(element, "rules element"));
            }
            return this;
        }

        public final Builder rules(@Nullable Iterable<? extends RuleEntity> elements) {
            if (elements == null) {
                this.rules = null;
                return this;
            }
            this.rules = new ArrayList<RuleEntity>();
            return this.addAllRules(elements);
        }

        public final Builder addAllRules(Iterable<? extends RuleEntity> elements) {
            Objects.requireNonNull(elements, "rules element");
            if (this.rules == null) {
                this.rules = new ArrayList<RuleEntity>();
            }
            for (RuleEntity ruleEntity : elements) {
                this.rules.add(Objects.requireNonNull(ruleEntity, "rules element"));
            }
            return this;
        }

        public final Builder spaceId(String element) {
            if (this.spaceIds == null) {
                this.spaceIds = new ArrayList<String>();
            }
            this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
            return this;
        }

        public final Builder spaceId(String ... elements) {
            if (this.spaceIds == null) {
                this.spaceIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
            }
            return this;
        }

        public final Builder spaceIds(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.spaceIds = null;
                return this;
            }
            this.spaceIds = new ArrayList<String>();
            return this.addAllSpaceIds(elements);
        }

        public final Builder addAllSpaceIds(Iterable<String> elements) {
            Objects.requireNonNull(elements, "spaceIds element");
            if (this.spaceIds == null) {
                this.spaceIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
            }
            return this;
        }

        public CreateSecurityGroupRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new CreateSecurityGroupRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build CreateSecurityGroupRequest, some of required attributes are not set " + attributes;
        }
    }
}

