/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.routes;

import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.client.v2.routes._AssociateRouteApplicationRequest;

public final class AssociateRouteApplicationRequest
extends _AssociateRouteApplicationRequest {
    private final String applicationId;
    private final String routeId;

    private AssociateRouteApplicationRequest(Builder builder) {
        this.applicationId = builder.applicationId;
        this.routeId = builder.routeId;
    }

    @Override
    public String getApplicationId() {
        return this.applicationId;
    }

    @Override
    public String getRouteId() {
        return this.routeId;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof AssociateRouteApplicationRequest && this.equalTo((AssociateRouteApplicationRequest)another);
    }

    private boolean equalTo(AssociateRouteApplicationRequest another) {
        return this.applicationId.equals(another.applicationId) && this.routeId.equals(another.routeId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.applicationId.hashCode();
        h += (h << 5) + this.routeId.hashCode();
        return h;
    }

    public String toString() {
        return "AssociateRouteApplicationRequest{applicationId=" + this.applicationId + ", routeId=" + this.routeId + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_APPLICATION_ID = 1L;
        private static final long INIT_BIT_ROUTE_ID = 2L;
        private long initBits = 3L;
        private String applicationId;
        private String routeId;

        private Builder() {
        }

        public final Builder from(AssociateRouteApplicationRequest instance) {
            return this.from((_AssociateRouteApplicationRequest)instance);
        }

        final Builder from(_AssociateRouteApplicationRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.applicationId(instance.getApplicationId());
            this.routeId(instance.getRouteId());
            return this;
        }

        public final Builder applicationId(String applicationId) {
            this.applicationId = Objects.requireNonNull(applicationId, "applicationId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder routeId(String routeId) {
            this.routeId = Objects.requireNonNull(routeId, "routeId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public AssociateRouteApplicationRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new AssociateRouteApplicationRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("applicationId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("routeId");
            }
            return "Cannot build AssociateRouteApplicationRequest, some of required attributes are not set " + attributes;
        }
    }
}

