/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.applications;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.applications.Resource;
import org.cloudfoundry.client.v2.applications._UploadApplicationRequest;

public final class UploadApplicationRequest
extends _UploadApplicationRequest {
    private final Path application;
    private final String applicationId;
    @Nullable
    private final Boolean async;
    private final List<Resource> resources;

    private UploadApplicationRequest(Builder builder) {
        this.application = builder.application;
        this.applicationId = builder.applicationId;
        this.async = builder.async;
        this.resources = UploadApplicationRequest.createUnmodifiableList(true, builder.resources);
    }

    @Override
    public Path getApplication() {
        return this.application;
    }

    @Override
    public String getApplicationId() {
        return this.applicationId;
    }

    @Override
    @Nullable
    public Boolean getAsync() {
        return this.async;
    }

    @Override
    public List<Resource> getResources() {
        return this.resources;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof UploadApplicationRequest && this.equalTo((UploadApplicationRequest)another);
    }

    private boolean equalTo(UploadApplicationRequest another) {
        return this.application.equals(another.application) && this.applicationId.equals(another.applicationId) && Objects.equals(this.async, another.async) && this.resources.equals(another.resources);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.application.hashCode();
        h += (h << 5) + this.applicationId.hashCode();
        h += (h << 5) + Objects.hashCode(this.async);
        h += (h << 5) + this.resources.hashCode();
        return h;
    }

    public String toString() {
        return "UploadApplicationRequest{application=" + this.application + ", applicationId=" + this.applicationId + ", async=" + this.async + ", resources=" + this.resources + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_APPLICATION = 1L;
        private static final long INIT_BIT_APPLICATION_ID = 2L;
        private long initBits = 3L;
        private Path application;
        private String applicationId;
        private Boolean async;
        private List<Resource> resources = new ArrayList<Resource>();

        private Builder() {
        }

        public final Builder from(UploadApplicationRequest instance) {
            return this.from((_UploadApplicationRequest)instance);
        }

        final Builder from(_UploadApplicationRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.application(instance.getApplication());
            this.applicationId(instance.getApplicationId());
            Boolean asyncValue = instance.getAsync();
            if (asyncValue != null) {
                this.async(asyncValue);
            }
            this.addAllResources(instance.getResources());
            return this;
        }

        public final Builder application(Path application) {
            this.application = Objects.requireNonNull(application, "application");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder applicationId(String applicationId) {
            this.applicationId = Objects.requireNonNull(applicationId, "applicationId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder async(@Nullable Boolean async) {
            this.async = async;
            return this;
        }

        public final Builder resource(Resource element) {
            this.resources.add(Objects.requireNonNull(element, "resources element"));
            return this;
        }

        public final Builder resource(Resource ... elements) {
            for (Resource element : elements) {
                this.resources.add(Objects.requireNonNull(element, "resources element"));
            }
            return this;
        }

        public final Builder resources(Iterable<? extends Resource> elements) {
            this.resources.clear();
            return this.addAllResources(elements);
        }

        public final Builder addAllResources(Iterable<? extends Resource> elements) {
            for (Resource resource : elements) {
                this.resources.add(Objects.requireNonNull(resource, "resources element"));
            }
            return this;
        }

        public UploadApplicationRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new UploadApplicationRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("application");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("applicationId");
            }
            return "Cannot build UploadApplicationRequest, some of required attributes are not set " + attributes;
        }
    }
}

