/*
 * Decompiled with CFR 0.152.
 */
package clojure.data.int_map;

import clojure.data.int_map.INode;
import clojure.data.int_map.ISet;
import clojure.data.int_map.Nodes;
import clojure.lang.AFn;
import clojure.lang.IFn;
import clojure.lang.MapEntry;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class IntSet
implements ISet {
    public final INode map;
    public final short leafSize;
    public final short log2LeafSize;
    public volatile int count = -1;

    public IntSet(short leafSize) {
        this.leafSize = leafSize;
        this.log2LeafSize = (short)Nodes.bitLog2(leafSize);
        this.map = Nodes.Empty.EMPTY;
    }

    IntSet(short leafSize, short log2LeafSize, INode map) {
        this.leafSize = leafSize;
        this.log2LeafSize = log2LeafSize;
        this.map = map;
    }

    public int leafSize() {
        return this.leafSize;
    }

    private long mapKey(long val) {
        return val >> this.log2LeafSize;
    }

    private short leafOffset(long val) {
        return (short)(val & (long)(this.leafSize - 1));
    }

    @Override
    public ISet add(final long epoch, final long val) {
        INode mapPrime = this.map.update(this.mapKey(val), epoch, (IFn)new AFn(){

            public Object invoke(Object v) {
                ISet s = (ISet)v;
                return s == null ? new SingleContainer(IntSet.this.leafOffset(val)) : s.add(epoch, IntSet.this.leafOffset(val));
            }
        });
        if (mapPrime == this.map) {
            this.count = -1;
            return this;
        }
        return new IntSet(this.leafSize, this.log2LeafSize, mapPrime);
    }

    @Override
    public ISet remove(final long epoch, final long val) {
        INode mapPrime = this.map.update(this.mapKey(val), epoch, (IFn)new AFn(){

            public Object invoke(Object v) {
                ISet s = (ISet)v;
                return s == null ? null : s.remove(epoch, IntSet.this.leafOffset(val));
            }
        });
        if (mapPrime == this.map) {
            this.count = -1;
            return this;
        }
        return new IntSet(this.leafSize, this.log2LeafSize, mapPrime);
    }

    @Override
    public boolean contains(long val) {
        ISet s = (ISet)this.map.get(this.mapKey(val), null);
        return s != null && s.contains(this.leafOffset(val));
    }

    @Override
    public ISet range(final long epoch, final long min, final long max) {
        if (max < min) {
            return new IntSet(this.leafSize);
        }
        if (this.mapKey(min) == this.mapKey(max)) {
            ISet set = (ISet)this.map.get(this.mapKey(min), null);
            set = set == null ? null : set.range(epoch, this.leafOffset(min), this.leafOffset(max));
            return set == null ? new IntSet(this.leafSize) : new IntSet(this.leafSize, this.log2LeafSize, Nodes.Empty.EMPTY.assoc(this.mapKey(min), epoch, null, set));
        }
        INode mapPrime = this.map.range(this.mapKey(min), this.mapKey(max));
        mapPrime = mapPrime == null ? Nodes.Empty.EMPTY : mapPrime.update(this.mapKey(min), epoch, (IFn)new AFn(){

            public Object invoke(Object v) {
                return v != null ? ((ISet)v).range(epoch, IntSet.this.leafOffset(min), IntSet.this.leafSize) : null;
            }
        }).update(this.mapKey(max), epoch, (IFn)new AFn(){

            public Object invoke(Object v) {
                return v != null ? ((ISet)v).range(epoch, 0L, IntSet.this.leafOffset(max)) : null;
            }
        });
        return new IntSet(this.leafSize, this.log2LeafSize, mapPrime);
    }

    @Override
    public Iterator elements(final long offset, final boolean reverse) {
        final Iterator it = this.map.iterator(INode.IterationType.ENTRIES, reverse);
        return new Iterator(){
            private Iterator parentIterator;
            private Iterator iterator;
            {
                this.parentIterator = it;
                this.iterator = null;
            }

            private void tryAdvance() {
                while ((this.iterator == null || !this.iterator.hasNext()) && this.parentIterator.hasNext()) {
                    MapEntry entry = (MapEntry)this.parentIterator.next();
                    ISet set = (ISet)entry.val();
                    long fullOffset = offset + (Long)entry.key() << IntSet.this.log2LeafSize;
                    this.iterator = set == null ? null : set.elements(fullOffset, reverse);
                }
            }

            @Override
            public boolean hasNext() {
                this.tryAdvance();
                return this.iterator == null ? false : this.iterator.hasNext();
            }

            public Object next() {
                this.tryAdvance();
                return this.iterator.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public long count() {
        if (this.count >= 0) {
            return this.count;
        }
        long cnt = 0L;
        Iterator i = this.map.iterator(INode.IterationType.VALS, false);
        while (i.hasNext()) {
            ISet s = (ISet)i.next();
            if (s == null) continue;
            cnt += s.count();
        }
        return cnt;
    }

    @Override
    public BitSet toBitSet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ISet intersection(long epoch, ISet sv) {
        IntSet s = (IntSet)sv;
        Iterator i1 = this.map.iterator(INode.IterationType.ENTRIES, false);
        Iterator i2 = s.map.iterator(INode.IterationType.ENTRIES, false);
        if (!i1.hasNext() || !i2.hasNext()) {
            return new IntSet(this.leafSize);
        }
        INode node = Nodes.Empty.EMPTY;
        MapEntry e1 = (MapEntry)i1.next();
        MapEntry e2 = (MapEntry)i2.next();
        while (true) {
            long k2;
            long k1;
            if ((k1 = ((Long)e1.key()).longValue()) == (k2 = ((Long)e2.key()).longValue()) && e1.val() != null && e2.val() != null) {
                node = node.assoc(k1, epoch, null, ((ISet)e1.val()).intersection(epoch, (ISet)e2.val()));
                if (!i1.hasNext() || !i2.hasNext()) break;
                e1 = (MapEntry)i1.next();
                e2 = (MapEntry)i2.next();
                continue;
            }
            if (k1 < k2) {
                if (!i1.hasNext()) break;
                e1 = (MapEntry)i1.next();
                continue;
            }
            if (!i2.hasNext()) break;
            e2 = (MapEntry)i2.next();
        }
        return new IntSet(this.leafSize, this.log2LeafSize, node);
    }

    @Override
    public ISet union(final long epoch, ISet sv) {
        IntSet s = (IntSet)sv;
        if (s.leafSize != this.leafSize) {
            throw new IllegalArgumentException("Cannot merge int-sets of different density.");
        }
        return new IntSet(this.leafSize, this.log2LeafSize, this.map.merge(s.map, epoch, (IFn)new AFn(){

            public Object invoke(Object a, Object b) {
                if (a == null) {
                    return b;
                }
                if (b == null) {
                    return a;
                }
                return ((ISet)a).union(epoch, (ISet)b);
            }
        }));
    }

    @Override
    public ISet difference(long epoch, ISet sv) {
        IntSet s = (IntSet)sv;
        Iterator i1 = this.map.iterator(INode.IterationType.ENTRIES, false);
        Iterator i2 = s.map.iterator(INode.IterationType.ENTRIES, false);
        if (!i1.hasNext() || !i2.hasNext()) {
            return this;
        }
        INode node = Nodes.Empty.EMPTY;
        MapEntry e1 = (MapEntry)i1.next();
        MapEntry e2 = (MapEntry)i2.next();
        while (true) {
            long k2;
            long k1;
            if ((k1 = ((Long)e1.key()).longValue()) == (k2 = ((Long)e2.key()).longValue()) && e1.val() != null && e2.val() != null) {
                node = node.assoc(k1, epoch, null, ((ISet)e1.val()).difference(epoch, (ISet)e2.val()));
                if (!i1.hasNext() || !i2.hasNext()) break;
                e1 = (MapEntry)i1.next();
                e2 = (MapEntry)i2.next();
                continue;
            }
            if (k1 <= k2 && e1.val() != null) {
                node = node.assoc(k1, epoch, null, e1.val());
                if (!i1.hasNext()) break;
                e1 = (MapEntry)i1.next();
                continue;
            }
            if (!i2.hasNext()) {
                node = node.assoc(k1, epoch, null, e1.val());
                break;
            }
            e2 = (MapEntry)i2.next();
        }
        while (i1.hasNext()) {
            e1 = (MapEntry)i1.next();
            node = node.assoc((Long)e1.key(), epoch, null, e1.val());
        }
        return new IntSet(this.leafSize, this.log2LeafSize, node);
    }

    public class SingleContainer
    implements ISet {
        public final short val;

        public SingleContainer(short val) {
            this.val = val;
        }

        @Override
        public ISet add(long epoch, long val) {
            if (val == (long)this.val) {
                return this;
            }
            BitSet bitSet = new BitSet(Math.max((short)val, this.val));
            bitSet.set((short)val);
            bitSet.set(this.val);
            return new BitSetContainer(epoch, bitSet);
        }

        @Override
        public ISet remove(long epoch, long val) {
            return val == (long)this.val ? null : this;
        }

        @Override
        public boolean contains(long val) {
            return val == (long)this.val;
        }

        @Override
        public ISet range(long epoch, long min, long max) {
            return min <= (long)this.val && max >= (long)this.val ? this : null;
        }

        @Override
        public long count() {
            return 1L;
        }

        @Override
        public Iterator elements(long offset, boolean reverse) {
            final long val = (long)this.val + offset;
            return new Iterator(){
                private boolean isDone = false;

                @Override
                public boolean hasNext() {
                    return !this.isDone;
                }

                public Object next() {
                    if (this.isDone) {
                        throw new NoSuchElementException();
                    }
                    this.isDone = true;
                    return val;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public BitSet toBitSet() {
            BitSet bitSet = new BitSet(this.val);
            bitSet.set(this.val);
            return bitSet;
        }

        @Override
        public ISet intersection(long epoch, ISet sv) {
            return sv == null ? null : (sv.contains(this.val) ? this : null);
        }

        @Override
        public ISet union(long epoch, ISet sv) {
            return sv == null ? this : (sv.contains(this.val) ? sv : sv.add(epoch, this.val));
        }

        @Override
        public ISet difference(long epoch, ISet sv) {
            return sv == null ? this : (sv.contains(this.val) ? null : this);
        }
    }

    public class BitSetContainer
    implements ISet {
        public final long epoch;
        public final BitSet bitSet;

        public BitSetContainer(long epoch, BitSet bitSet) {
            this.epoch = epoch;
            this.bitSet = bitSet;
        }

        @Override
        public ISet add(long epoch, long val) {
            if (epoch == this.epoch) {
                this.bitSet.set((short)val);
                return this;
            }
            BitSet bitSet = (BitSet)this.bitSet.clone();
            bitSet.set((short)val);
            return new BitSetContainer(epoch, bitSet);
        }

        @Override
        public ISet remove(long epoch, long val) {
            if (epoch == this.epoch) {
                this.bitSet.set((int)((short)val), false);
                return this;
            }
            BitSet bitSet = (BitSet)this.bitSet.clone();
            bitSet.set((int)((short)val), false);
            return new BitSetContainer(epoch, bitSet);
        }

        @Override
        public boolean contains(long val) {
            return this.bitSet.get((short)val);
        }

        @Override
        public ISet range(long epoch, long min, long max) {
            BitSet bitSet = (BitSet)this.bitSet.clone();
            int size = bitSet.size();
            bitSet.set(0, Math.max((short)min, 0), false);
            if (max < (long)size) {
                bitSet.set(Math.min((short)max + 1, size), size, false);
            }
            return new BitSetContainer(epoch, bitSet);
        }

        @Override
        public Iterator elements(long offset, boolean reverse) {
            ArrayList<Long> ns = new ArrayList<Long>(this.bitSet.cardinality());
            for (int idx = 0; idx < this.bitSet.length(); ++idx) {
                idx = this.bitSet.nextSetBit(idx);
                ns.add(offset + (long)idx);
            }
            if (reverse) {
                Collections.reverse(ns);
            }
            return ns.iterator();
        }

        @Override
        public long count() {
            return this.bitSet.cardinality();
        }

        @Override
        public BitSet toBitSet() {
            return this.bitSet;
        }

        @Override
        public ISet intersection(long epoch, ISet val) {
            BitSet bitSet = (BitSet)this.bitSet.clone();
            bitSet.and(val.toBitSet());
            return new BitSetContainer(epoch, bitSet);
        }

        @Override
        public ISet union(long epoch, ISet val) {
            BitSet bitSet = (BitSet)this.bitSet.clone();
            bitSet.or(val.toBitSet());
            return new BitSetContainer(epoch, bitSet);
        }

        @Override
        public ISet difference(long epoch, ISet val) {
            BitSet bitSet = (BitSet)this.bitSet.clone();
            bitSet.andNot(val.toBitSet());
            return new BitSetContainer(epoch, bitSet);
        }
    }
}

