/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.IFn;
import clojure.lang.IHashEq;
import clojure.lang.IPending;
import clojure.lang.IPersistentCollection;
import clojure.lang.IPersistentMap;
import clojure.lang.ISeq;
import clojure.lang.Murmur3;
import clojure.lang.Obj;
import clojure.lang.PersistentList;
import clojure.lang.RT;
import clojure.lang.SeqIterator;
import clojure.lang.Sequential;
import clojure.lang.Util;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public final class LazySeq
extends Obj
implements ISeq,
Sequential,
List,
IPending,
IHashEq {
    private static final long serialVersionUID = -7531333024710395876L;
    private transient IFn fn;
    private Object sv;
    private ISeq s;
    private volatile Lock lock;

    public LazySeq(IFn f) {
        this.fn = f;
        this.lock = new ReentrantLock();
    }

    private LazySeq(IPersistentMap meta, ISeq seq) {
        super(meta);
        this.fn = null;
        this.s = seq;
    }

    @Override
    public Obj withMeta(IPersistentMap meta) {
        if (this.meta() == meta) {
            return this;
        }
        return new LazySeq(meta, this.seq());
    }

    private final void force() {
        if (this.fn != null) {
            this.sv = this.fn.invoke();
            this.fn = null;
        }
    }

    private final Object sval() {
        Lock l = this.lock;
        if (l != null) {
            l.lock();
            try {
                if (this.lock != null) {
                    this.force();
                    Object object = this.sv;
                    return object;
                }
            }
            finally {
                l.unlock();
            }
        }
        return this.s;
    }

    private final Object unwrap(Object ls) {
        while (ls instanceof LazySeq) {
            ls = ((LazySeq)ls).sval();
        }
        return ls;
    }

    private final void realize() {
        Lock l = this.lock;
        if (l != null) {
            l.lock();
            try {
                if (this.lock != null) {
                    this.force();
                    Object ls = this.sv;
                    this.sv = null;
                    if (ls instanceof LazySeq) {
                        ls = this.unwrap(ls);
                    }
                    this.s = RT.seq(ls);
                    this.lock = null;
                }
            }
            finally {
                l.unlock();
            }
        }
    }

    @Override
    public final ISeq seq() {
        if (this.lock != null) {
            this.realize();
        }
        return this.s;
    }

    @Override
    public int count() {
        int c = 0;
        for (ISeq s = this.seq(); s != null; s = s.next()) {
            ++c;
        }
        return c;
    }

    @Override
    public Object first() {
        this.seq();
        if (this.s == null) {
            return null;
        }
        return this.s.first();
    }

    @Override
    public ISeq next() {
        this.seq();
        if (this.s == null) {
            return null;
        }
        return this.s.next();
    }

    @Override
    public ISeq more() {
        this.seq();
        if (this.s == null) {
            return PersistentList.EMPTY;
        }
        return this.s.more();
    }

    @Override
    public ISeq cons(Object o) {
        return RT.cons(o, this.seq());
    }

    @Override
    public IPersistentCollection empty() {
        return PersistentList.EMPTY;
    }

    @Override
    public boolean equiv(Object o) {
        ISeq s = this.seq();
        if (s != null) {
            return s.equiv(o);
        }
        return (o instanceof Sequential || o instanceof List) && RT.seq(o) == null;
    }

    @Override
    public int hashCode() {
        ISeq s = this.seq();
        if (s == null) {
            return 1;
        }
        return Util.hash(s);
    }

    @Override
    public int hasheq() {
        return Murmur3.hashOrdered(this);
    }

    @Override
    public boolean equals(Object o) {
        ISeq s = this.seq();
        if (s != null) {
            return s.equals(o);
        }
        return (o instanceof Sequential || o instanceof List) && RT.seq(o) == null;
    }

    @Override
    public Object[] toArray() {
        return RT.seqToArray(this.seq());
    }

    @Override
    public boolean add(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object[] toArray(Object[] a) {
        return RT.seqToPassedArray(this.seq(), a);
    }

    @Override
    public int size() {
        return this.count();
    }

    @Override
    public boolean isEmpty() {
        return this.seq() == null;
    }

    @Override
    public boolean contains(Object o) {
        for (ISeq s = this.seq(); s != null; s = s.next()) {
            if (!Util.equiv(s.first(), o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator iterator() {
        return new SeqIterator(this);
    }

    private List reify() {
        return new ArrayList(this);
    }

    public List subList(int fromIndex, int toIndex) {
        return this.reify().subList(fromIndex, toIndex);
    }

    public Object set(int index2, Object element) {
        throw new UnsupportedOperationException();
    }

    public Object remove(int index2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int indexOf(Object o) {
        ISeq s = this.seq();
        int i = 0;
        while (s != null) {
            if (Util.equiv(s.first(), o)) {
                return i;
            }
            s = s.next();
            ++i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.reify().lastIndexOf(o);
    }

    public ListIterator listIterator() {
        return this.reify().listIterator();
    }

    public ListIterator listIterator(int index2) {
        return this.reify().listIterator(index2);
    }

    public Object get(int index2) {
        return RT.nth(this, index2);
    }

    public void add(int index2, Object element) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(int index2, Collection c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isRealized() {
        return this.lock == null;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        for (ISeq s = this; s != null; s = s.next()) {
        }
        out.defaultWriteObject();
    }
}

