/*
 * Decompiled with CFR 0.152.
 */
package nl.captcha.servlet;

import java.io.IOException;
import java.util.Date;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import nl.captcha.Captcha;
import nl.captcha.servlet.CaptchaServletUtil;

public class StickyCaptchaServlet
extends HttpServlet {
    private static final long serialVersionUID = 40913456229L;
    private static int _width = 200;
    private static int _height = 50;
    private static long _ttl = 600000L;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (this.getInitParameter("captcha-height") != null) {
            _height = Integer.valueOf(this.getInitParameter("captcha-height"));
        }
        if (this.getInitParameter("captcha-width") != null) {
            _width = Integer.valueOf(this.getInitParameter("captcha-width"));
        }
        if (this.getInitParameter("ttl") != null) {
            _ttl = Long.valueOf(this.getInitParameter("ttl"));
        }
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        HttpSession session = req.getSession();
        if (session.getAttribute("simpleCaptcha") == null) {
            Captcha captcha = this.buildAndSetCaptcha(session);
            return;
        }
        Captcha captcha = (Captcha)session.getAttribute("simpleCaptcha");
        if (StickyCaptchaServlet.shouldExpire(captcha)) {
            captcha = this.buildAndSetCaptcha(session);
            return;
        }
        CaptchaServletUtil.writeImage(resp, captcha.getImage());
    }

    private Captcha buildAndSetCaptcha(HttpSession session) {
        Captcha captcha = new Captcha.Builder(_width, _height).addText().gimp().addBorder().addNoise().addBackground().build();
        session.setAttribute("simpleCaptcha", (Object)captcha);
        return captcha;
    }

    static void setTtl(long ttl) {
        if (ttl < 0L) {
            ttl = 0L;
        }
        _ttl = ttl;
    }

    static long getTtl() {
        return _ttl;
    }

    static boolean shouldExpire(Captcha captcha) {
        long ts = captcha.getTimeStamp().getTime();
        long now = new Date().getTime();
        long diff = now - ts;
        return diff >= _ttl;
    }
}

