/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.Colormap;
import com.jhlabs.image.Gradient;
import com.jhlabs.image.WholeImageFilter;
import java.util.Random;

public class ReactDiffuse
extends WholeImageFilter {
    private Random random;
    public int iterations = 20;
    public double xScale = 1.0;
    public double yScale = 1.0;
    public double amount = 1.0;
    public boolean spots = true;
    private boolean initialized = false;
    private int width = 64;
    private int height = 64;
    private int value_switch = 1;
    private float[][] a;
    private float[][] b;
    private float[][] c;
    private float[][] d;
    private float[][] e;
    private float[][] da;
    private float[][] db;
    private float[][] dc;
    private float[][] dd;
    private float[][] de;
    private float[][] ai;
    private double minValue;
    private double maxValue;
    public double p1 = 0.04;
    public double p2 = 0.06;
    public double p3 = 0.04;
    private double diff1;
    private double diff2;
    private double arand;
    private double a_steady;
    private double b_steady;
    private double beta_init;
    private double beta_rand;
    private double speed = 1.0;
    private Colormap colormap = new Gradient();

    public void setColormap(Colormap colormap) {
        this.colormap = colormap;
    }

    public Colormap getColormap() {
        return this.colormap;
    }

    public void setSpeed(double d) {
        this.speed = d;
    }

    public double getSpeed() {
        return this.speed;
    }

    public void initialize(int n, int n2) {
        this.a = new float[n][n2];
        this.b = new float[n][n2];
        this.c = new float[n][n2];
        this.d = new float[n][n2];
        this.e = new float[n][n2];
        this.da = new float[n][n2];
        this.db = new float[n][n2];
        this.dc = new float[n][n2];
        this.dd = new float[n][n2];
        this.de = new float[n][n2];
        this.ai = new float[n][n2];
    }

    public void stripes(int[] nArray, int n, int n2) {
        this.diff1 = 0.009;
        this.diff2 = 0.2;
        this.arand = 0.02;
        this.value_switch = 1;
        this.compute(nArray, n, n2);
    }

    public void spots(int[] nArray, int n, int n2) {
        this.beta_init = 12.0;
        this.beta_rand = 0.1;
        this.a_steady = 4.0;
        this.b_steady = 4.0;
        this.diff1 = 0.25;
        this.diff2 = 0.0625;
        this.p1 = 0.2;
        this.p2 = 0.0;
        this.p3 = 0.0;
        this.value_switch = 2;
        this.compute(nArray, n, n2);
    }

    private void compute(int[] nArray, int n, int n2) {
        this.calcSemistableEquilibria(nArray, n, n2);
        int n3 = 0;
        while (n3 < this.iterations) {
            if (this.spots) {
                this.turing();
            } else {
                this.multiplicative_help();
            }
            ++n3;
        }
        switch (this.value_switch) {
            case 1: {
                this.normalize(this.a);
                break;
            }
            case 2: {
                this.normalize(this.b);
                break;
            }
            case 3: {
                this.normalize(this.c);
                break;
            }
            case 4: {
                this.normalize(this.d);
                break;
            }
            case 5: {
                this.normalize(this.e);
                break;
            }
        }
    }

    private void multiplicative_help() {
        int n;
        int n2 = 0;
        while (n2 < this.width) {
            double d = -this.p1 - 4.0 * this.diff1;
            double d2 = -this.p2;
            double d3 = -this.p3 - 4.0 * this.diff2;
            int n3 = (n2 + this.width - 1) % this.width;
            int n4 = (n2 + 1) % this.width;
            n = 0;
            while (n < this.height) {
                int n5 = (n + this.height - 1) % this.height;
                int n6 = (n + 1) % this.height;
                double d4 = this.a[n2][n];
                double d5 = this.b[n2][n];
                double d6 = this.c[n2][n];
                double d7 = this.d[n2][n];
                double d8 = this.e[n2][n];
                double d9 = 0.01 * d4 * d4 * d8 * (double)this.ai[n2][n];
                double d10 = 0.01 * d5 * d5 * d7;
                double d11 = this.a[n2][n5] + this.a[n2][n6] + this.a[n3][n] + this.a[n4][n];
                double d12 = this.b[n2][n5] + this.b[n2][n6] + this.b[n3][n] + this.b[n4][n];
                double d13 = this.d[n2][n5] + this.d[n2][n6] + this.d[n3][n] + this.d[n4][n];
                double d14 = this.e[n2][n5] + this.e[n2][n6] + this.e[n3][n] + this.e[n4][n];
                this.da[n2][n] = (float)(d4 * d + this.diff1 * d11 + d9 / d6);
                this.db[n2][n] = (float)(d5 * d + this.diff1 * d12 + d10 / d6);
                this.dc[n2][n] = (float)(d6 * d2 + d9 + d10);
                this.dd[n2][n] = (float)(d7 * d3 + this.diff2 * d13 + this.p3 * d4);
                this.de[n2][n] = (float)(d8 * d3 + this.diff2 * d14 + this.p3 * d5);
                ++n;
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < this.width) {
            n = 0;
            while (n < this.height) {
                float[] fArray = this.a[n2];
                int n7 = n;
                fArray[n7] = fArray[n7] + (float)(this.speed * (double)this.da[n2][n]);
                float[] fArray2 = this.b[n2];
                int n8 = n;
                fArray2[n8] = fArray2[n8] + (float)(this.speed * (double)this.db[n2][n]);
                float[] fArray3 = this.c[n2];
                int n9 = n;
                fArray3[n9] = fArray3[n9] + (float)(this.speed * (double)this.dc[n2][n]);
                float[] fArray4 = this.d[n2];
                int n10 = n;
                fArray4[n10] = fArray4[n10] + (float)(this.speed * (double)this.dd[n2][n]);
                float[] fArray5 = this.e[n2];
                int n11 = n;
                fArray5[n11] = fArray5[n11] + (float)(this.speed * (double)this.de[n2][n]);
                ++n;
            }
            ++n2;
        }
    }

    private void turing() {
        int n;
        double d = this.diff1 / 2.0;
        double d2 = this.diff2 / 2.0;
        double d3 = this.p1 / 16.0;
        int n2 = 0;
        while (n2 < this.width) {
            int n3 = (n2 + this.width - 1) % this.width;
            int n4 = (n2 + 1) % this.width;
            n = 0;
            while (n < this.height) {
                int n5 = (n + this.height - 1) % this.height;
                int n6 = (n + 1) % this.height;
                double d4 = this.a[n2][n];
                double d5 = this.b[n2][n];
                double d6 = (double)(this.a[n2][n5] + this.a[n2][n6] + this.a[n3][n] + this.a[n4][n]) - 4.0 * d4;
                double d7 = (double)(this.b[n2][n5] + this.b[n2][n6] + this.b[n3][n] + this.b[n4][n]) - 4.0 * d5;
                this.da[n2][n] = (float)(d3 * (16.0 - d4 * d5) + d * d6);
                this.db[n2][n] = (float)(d3 * (d4 * d5 - d5 - (double)this.c[n2][n]) + d2 * d7);
                ++n;
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < this.width) {
            n = 0;
            while (n < this.height) {
                float[] fArray = this.a[n2];
                int n7 = n;
                fArray[n7] = (float)((double)fArray[n7] + this.speed * (double)this.da[n2][n]);
                float[] fArray2 = this.b[n2];
                int n8 = n;
                fArray2[n8] = (float)((double)fArray2[n8] + this.speed * (double)this.db[n2][n]);
                if (this.b[n2][n] < 0.0f) {
                    this.b[n2][n] = 0.0f;
                }
                ++n;
            }
            ++n2;
        }
    }

    private void calcSemistableEquilibria(int[] nArray, int n, int n2) {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        int n3 = 0;
        if (this.spots) {
            d5 = 0.0;
            d4 = 0.0;
            d3 = 0.0;
            d2 = 0.0;
            d = 0.0;
        } else {
            d2 = d = this.p2 / (2.0 * this.p1);
            d3 = 0.02 * d * d * d / this.p2;
            d4 = d;
            d5 = d;
        }
        int n4 = 0;
        while (n4 < n2) {
            int n5 = 0;
            while (n5 < n) {
                int n6 = nArray[n3++];
                int n7 = n6 >> 16 & 0xFF;
                int n8 = n6 >> 8 & 0xFF;
                int n9 = n6 & 0xFF;
                float f = (float)(n7 + n8 + n9) / 3.0f / 255.0f;
                if (this.spots) {
                    this.a[n5][n4] = (float)this.a_steady;
                    this.b[n5][n4] = (float)this.b_steady;
                    this.c[n5][n4] = f;
                } else {
                    this.a[n5][n4] = (float)d;
                    this.b[n5][n4] = (float)d2;
                    this.c[n5][n4] = (float)d3;
                    this.d[n5][n4] = (float)d4;
                    this.e[n5][n4] = (float)d5;
                    this.ai[n5][n4] = f;
                }
                ++n5;
            }
            ++n4;
        }
    }

    private void normalize(float[][] fArray) {
        double d = 1.0E20;
        double d2 = -1.0E20;
        int n = 0;
        while (n < this.width) {
            int n2 = 0;
            while (n2 < this.height) {
                d = Math.min(d, (double)fArray[n][n2]);
                d2 = Math.max(d2, (double)fArray[n][n2]);
                ++n2;
            }
            ++n;
        }
        if (d == d2) {
            d = d2 - 1.0;
            d2 = d + 2.0;
        }
        this.minValue = d;
        this.maxValue = d2;
    }

    private double frand(double d, double d2) {
        return d + this.random.nextDouble() * (d2 - d);
    }

    public void imageComplete(int n) {
        if (n == 1 || n == 4) {
            this.consumer.imageComplete(n);
            return;
        }
        this.random = new Random(0L);
        this.width = this.originalSpace.width;
        this.height = this.originalSpace.height;
        int n2 = 0;
        this.initialize(this.width, this.height);
        if (this.spots) {
            this.spots(this.inPixels, this.width, this.height);
        } else {
            this.stripes(this.inPixels, this.width, this.height);
        }
        int[] nArray = new int[this.width * this.height];
        n2 = 0;
        float[][] fArray = this.value_switch == 2 ? this.b : this.a;
        int n3 = 0;
        while (n3 < this.height) {
            int n4 = 0;
            while (n4 < this.width) {
                nArray[n2++] = this.colormap.getColor(this.amount * ((double)fArray[n4 % this.width][n3 % this.height] - this.minValue) / (this.maxValue - this.minValue));
                ++n4;
            }
            ++n3;
        }
        this.consumer.setPixels(0, 0, this.width, this.height, this.defaultRGBModel, nArray, 0, this.width);
        this.consumer.imageComplete(n);
        this.inPixels = null;
    }

    public String toString() {
        return "Texture/Reaction-diffusion...";
    }
}

