/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.util;

import com.softsynth.util.IndentingWriter;
import com.softsynth.util.XMLTools;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Stack;

public class XMLWriter
extends IndentingWriter {
    Stack tagStack = new Stack();
    boolean hasContent = false;

    public XMLWriter(OutputStream outputStream) {
        super(outputStream);
    }

    public XMLWriter(Writer writer) {
        super(writer);
    }

    public void writeAttribute(String string, String string2) {
        this.print(" " + string + "=\"" + XMLTools.escapeText(string2) + "\"");
    }

    public void writeAttribute(String string, int n) {
        this.writeAttribute(string, Integer.toString(n));
    }

    public void writeAttribute(String string, long l) {
        this.writeAttribute(string, Long.toString(l));
    }

    public void writeAttribute(String string, double d) {
        this.writeAttribute(string, Double.toString(d));
    }

    public void writeAttribute(String string, boolean bl) {
        this.writeAttribute(string, bl ? "1" : "0");
    }

    public void writeHeader() {
        this.println("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
    }

    public void startTag(String string) {
        this.beginTag(string);
    }

    public void beginTag(String string) {
        if (!this.hasContent && this.tagStack.size() > 0) {
            this.beginContent();
            this.println();
        }
        this.print("<" + string);
        this.tagStack.push(string);
        this.hasContent = false;
        this.indent();
    }

    public void endTag() {
        this.undent();
        String string = (String)this.tagStack.pop();
        if (this.hasContent) {
            this.println("</" + string + ">");
        } else {
            this.println(" />");
        }
        this.hasContent = !this.tagStack.isEmpty();
    }

    public void beginContent() {
        this.print(">");
        this.hasContent = true;
    }

    public void endContent() {
    }

    public void writeComment(String string) throws IOException {
        if (!this.hasContent && this.tagStack.size() > 0) {
            this.beginContent();
            this.println();
        }
        this.println("<!-- " + XMLTools.escapeText(string) + "-->");
    }

    public void writeContent(String string) {
        this.beginContent();
        this.print(XMLTools.escapeText(string));
        this.endContent();
    }

    public void writeTag(String string, String string2) {
        this.beginTag(string);
        this.writeContent(string2);
        this.endTag();
    }
}

