/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.util;

import com.softsynth.util.XMLListener;
import com.softsynth.util.XMLTools;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.io.StreamCorruptedException;
import java.util.Hashtable;

public class XMLReader
extends PushbackInputStream {
    XMLListener listener;
    static final int IDLE = 0;
    static final int INTAG = 0;
    static int depth = 0;
    static final int STATE_TOP = 0;
    static final int STATE_TAG_NAME = 1;
    static final int STATE_TAG_FIND_ANGLE = 2;
    static final int STATE_TAG_ATTR_NAME = 3;
    static final int STATE_TAG_FIND_EQUAL = 4;
    static final int STATE_TAG_FIND_QUOTE = 5;
    static final int STATE_TAG_ATTR_VALUE = 6;
    static final int STATE_CONTENT = 7;
    static final int STATE_CHECK_END = 8;
    static final int STATE_TAG_SKIP = 9;

    public void setXMLListener(XMLListener xMLListener) {
        this.listener = xMLListener;
    }

    public XMLReader(InputStream inputStream) {
        super(inputStream);
    }

    private int readChar() throws IOException {
        int n = this.read();
        if (n < 0) {
            return n;
        }
        if (n < 128) {
            return n;
        }
        byte[] byArray = null;
        if (n < 224) {
            byArray = new byte[2];
        } else if (n < 240) {
            byArray = new byte[3];
        } else if (n < 248) {
            byArray = new byte[4];
        } else if (n < 252) {
            byArray = new byte[5];
        } else if (n < 254) {
            byArray = new byte[6];
        }
        byArray[0] = (byte)n;
        for (int i = 1; i < byArray.length; ++i) {
            n = this.read();
            if ((n & 0xC0) != 128) {
                throw new IOException("invalid UTF8 continuation " + Integer.toHexString(n));
            }
            byArray[i] = (byte)n;
        }
        return new String(byArray, "UTF8").charAt(0);
    }

    public void parse() throws IOException {
        int n;
        while ((n = this.readChar()) >= 0) {
            char c = (char)n;
            if (c == '<') {
                this.parseElement();
                continue;
            }
            if (Character.isWhitespace(c)) continue;
            throw new StreamCorruptedException("Unexpected character. This doesn't look like an XML file!");
        }
    }

    String charToString(char c) {
        String string;
        switch (c) {
            case '\r': {
                string = "\\r";
                break;
            }
            case '\n': {
                string = "\\n";
                break;
            }
            case '\t': {
                string = "\\t";
                break;
            }
            default: {
                string = Character.isWhitespace(c) ? " " : "" + c;
            }
        }
        return string;
    }

    boolean isStringWhite(String string) {
        if (string == null) {
            return true;
        }
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (Character.isWhitespace(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    void parseElement() throws IOException {
        int n = 1;
        String string = "";
        String string2 = null;
        String string3 = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = true;
        char c = '\"';
        String string4 = null;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        while (!bl3) {
            char c2;
            do {
                int n2;
                if ((n2 = this.readChar()) < 0) {
                    throw new EOFException("EOF inside element!");
                }
                c2 = (char)n2;
            } while (bl4 && Character.isWhitespace(c2));
            bl4 = false;
            switch (n) {
                case 1: {
                    if (Character.isWhitespace(c2)) {
                        bl4 = true;
                        n = 2;
                        break;
                    }
                    if (c2 == '/') {
                        bl = true;
                        n = 2;
                        break;
                    }
                    if (c2 == '>') {
                        if (bl2) {
                            this.listener.endElement(string);
                            bl3 = true;
                            break;
                        }
                        this.listener.beginElement(string, hashtable, bl);
                        n = 7;
                        break;
                    }
                    if (c2 == '?') {
                        n = 9;
                        break;
                    }
                    if (c2 == '!') {
                        n = 9;
                        break;
                    }
                    string = string + c2;
                    break;
                }
                case 9: {
                    if (c2 != '>') break;
                    bl3 = true;
                    break;
                }
                case 2: {
                    if (c2 == '/') {
                        bl = true;
                        break;
                    }
                    if (c2 == '>') {
                        if (bl2) {
                            this.listener.endElement(string);
                            bl3 = true;
                            break;
                        }
                        this.listener.beginElement(string, hashtable, bl);
                        n = 7;
                        bl3 = bl;
                        break;
                    }
                    n = 3;
                    string2 = "" + c2;
                    break;
                }
                case 3: {
                    if (Character.isWhitespace(c2)) {
                        bl4 = true;
                        n = 4;
                        break;
                    }
                    if (c2 == '=') {
                        bl4 = true;
                        n = 5;
                        break;
                    }
                    string2 = string2 + c2;
                    break;
                }
                case 4: {
                    if (c2 == '=') {
                        bl4 = true;
                        n = 5;
                        break;
                    }
                    throw new StreamCorruptedException("Found " + this.charToString(c2) + ", expected =.");
                }
                case 5: {
                    if (c2 == '\"') {
                        n = 6;
                        string3 = "";
                        c = '\"';
                        break;
                    }
                    if (c2 == '\'') {
                        n = 6;
                        string3 = "";
                        c = '\'';
                        break;
                    }
                    throw new StreamCorruptedException("Found " + this.charToString(c2) + ", expected '\"'.");
                }
                case 6: {
                    if (c2 == c) {
                        hashtable.put(string2, string3);
                        bl4 = true;
                        n = 2;
                        break;
                    }
                    string3 = string3 + c2;
                    break;
                }
                case 7: {
                    if (c2 == '<') {
                        n = 8;
                        if (!this.isStringWhite(string4)) {
                            String string5 = XMLTools.unescapeText(string4);
                            this.listener.foundContent(string5);
                        }
                        string4 = null;
                        break;
                    }
                    if (string4 == null) {
                        string4 = "";
                    }
                    string4 = string4 + c2;
                    break;
                }
                case 8: {
                    if (c2 == '/') {
                        bl2 = true;
                        n = 1;
                        string = "";
                        break;
                    }
                    this.unread(c2);
                    this.parseElement();
                    n = 7;
                }
            }
        }
    }

    public static int getAttribute(Hashtable hashtable, String string, int n) {
        String string2 = (String)hashtable.get(string);
        return string2 == null ? n : Integer.parseInt(string2);
    }

    public static double getAttribute(Hashtable hashtable, String string, double d) {
        String string2 = (String)hashtable.get(string);
        return string2 == null ? d : Double.valueOf(string2);
    }
}

