/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.util;

import com.softsynth.util.TextOutput;
import com.softsynth.util.WildcardFilenameFilter;
import java.io.File;
import java.util.Enumeration;
import java.util.Vector;

public class FileSearch {
    public static Vector expandFilenames(Vector vector) {
        Vector vector2 = new Vector();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            FileSearch.expandFilename((String)enumeration.nextElement(), vector2);
        }
        return vector2;
    }

    public static void expandFilename(String string, Vector vector) {
        int n = string.lastIndexOf(File.separatorChar);
        int n2 = string.indexOf(42);
        if (n2 < 0) {
            vector.addElement(string);
        } else if (n2 < n) {
            TextOutput.error("Wildcard * not allowed in directory names! " + string);
        } else {
            String[] stringArray;
            String string2;
            String string3;
            if (n < 0) {
                string3 = ".";
                string2 = string;
            } else {
                string3 = string.substring(0, n);
                string2 = string.substring(n + 1);
            }
            File file = new File(string3);
            if (!file.exists()) {
                TextOutput.error("Invalid directory = " + string3);
            }
            if ((stringArray = file.list(new WildcardFilenameFilter(string2))) == null) {
                return;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                vector.addElement(string3 + File.separatorChar + stringArray[i]);
            }
        }
    }

    public static String removeParent(String string) {
        int n = string.lastIndexOf(File.separatorChar);
        if (n < 0) {
            return string;
        }
        return string.substring(n + 1);
    }

    public static String removeExtension(String string) {
        int n = string.lastIndexOf(46);
        if (n > 0) {
            return string.substring(0, n);
        }
        return string;
    }

    public static void main(String[] stringArray) {
        System.out.println("FileSearch - by Phil Burk");
        boolean bl = WildcardFilenameFilter.wildMatch("abc*frog*xyz", "abctreefroglegxyz");
        System.out.println("result = " + bl);
        bl = WildcardFilenameFilter.wildMatch("abc*frog*xyz", "abctreefrxglegxyz");
        System.out.println("result = " + bl);
        FileSearch.test();
    }

    static void test() {
        Vector vector = new Vector();
        FileSearch.expandFilename("../data/ov*.mid", vector);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            System.out.println("file = " + string);
        }
    }

    public static void createDirectoryIfNeeded(String string) throws SecurityException {
        FileSearch.createDirectoryIfNeeded(new File(string));
    }

    public static void createDirectoryIfNeeded(File file) throws SecurityException {
        if (!file.isDirectory() && !file.mkdirs()) {
            TextOutput.error("Could not make output directory " + file.getAbsolutePath());
        }
    }
}

