/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.shared.time;

import com.softsynth.shared.time.TimeStamp;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScheduledQueue<T> {
    private SortedMap<TimeStamp, List<T>> timeNodes = new TreeMap<TimeStamp, List<T>>();

    public boolean isEmpty() {
        return this.timeNodes.isEmpty();
    }

    public synchronized void add(TimeStamp timeStamp, T t) {
        LinkedList<T> linkedList = (LinkedList<T>)this.timeNodes.get(timeStamp);
        if (linkedList == null) {
            linkedList = new LinkedList<T>();
            this.timeNodes.put(timeStamp, linkedList);
        }
        linkedList.add(t);
    }

    public synchronized List<T> removeNextList(TimeStamp timeStamp) {
        TimeStamp timeStamp2;
        List list = null;
        if (!this.timeNodes.isEmpty() && (timeStamp2 = this.timeNodes.firstKey()).compareTo(timeStamp) <= 0) {
            list = (List)this.timeNodes.remove(timeStamp2);
        }
        return list;
    }

    public synchronized Object removeNext(TimeStamp timeStamp) {
        List list;
        TimeStamp timeStamp2;
        Object var2_2 = null;
        if (!this.timeNodes.isEmpty() && (timeStamp2 = this.timeNodes.firstKey()).compareTo(timeStamp) <= 0 && (list = (List)this.timeNodes.get(timeStamp2)) != null) {
            var2_2 = list.remove(0);
            if (list.isEmpty()) {
                this.timeNodes.remove(timeStamp2);
            }
        }
        return var2_2;
    }

    public TimeStamp getNextTime() {
        return this.timeNodes.firstKey();
    }
}

