/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.math;

import com.softsynth.math.JustRatio;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrimeFactors {
    private static final int SIEVE_SIZE = 1000;
    private static int[] primes;
    private final int[] factors;

    private static int[] primeListToArray(ArrayList<Integer> arrayList) {
        int[] nArray = new int[arrayList.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = arrayList.get(i);
        }
        return nArray;
    }

    public PrimeFactors(int[] nArray) {
        this.factors = nArray;
    }

    public PrimeFactors(int n, int n2) {
        int[] nArray = PrimeFactors.factor(n);
        int[] nArray2 = PrimeFactors.factor(n2);
        this.factors = PrimeFactors.subtract(nArray, nArray2);
    }

    public PrimeFactors subtract(PrimeFactors primeFactors) {
        return new PrimeFactors(PrimeFactors.subtract(this.factors, primeFactors.factors));
    }

    public PrimeFactors add(PrimeFactors primeFactors) {
        return new PrimeFactors(PrimeFactors.add(this.factors, primeFactors.factors));
    }

    public static int[] subtract(int[] nArray, int[] nArray2) {
        int n;
        int n2;
        int n3;
        if (nArray.length > nArray2.length) {
            n3 = nArray.length;
            n2 = nArray2.length;
        } else {
            n2 = nArray.length;
            n3 = nArray2.length;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (n = 0; n < n2; ++n) {
            arrayList.add(nArray[n] - nArray2[n]);
        }
        if (nArray.length > nArray2.length) {
            while (n < n3) {
                arrayList.add(nArray[n]);
                ++n;
            }
        } else {
            while (n < n3) {
                arrayList.add(0 - nArray2[n]);
                ++n;
            }
        }
        PrimeFactors.trimPrimeList(arrayList);
        return PrimeFactors.primeListToArray(arrayList);
    }

    public static int[] add(int[] nArray, int[] nArray2) {
        int n;
        int n2;
        int n3;
        if (nArray.length > nArray2.length) {
            n3 = nArray.length;
            n2 = nArray2.length;
        } else {
            n2 = nArray.length;
            n3 = nArray2.length;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (n = 0; n < n2; ++n) {
            arrayList.add(nArray[n] + nArray2[n]);
        }
        if (nArray.length > nArray2.length) {
            while (n < n3) {
                arrayList.add(nArray[n]);
                ++n;
            }
        } else if (nArray2.length > nArray.length) {
            while (n < n3) {
                arrayList.add(nArray2[n]);
                ++n;
            }
        }
        PrimeFactors.trimPrimeList(arrayList);
        return PrimeFactors.primeListToArray(arrayList);
    }

    private static void trimPrimeList(ArrayList<Integer> arrayList) {
        for (int i = arrayList.size() - 1; i >= 0 && arrayList.get(i) == 0; --i) {
            arrayList.remove(i);
        }
    }

    public static int[] factor(int n) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n2 = 0;
        int n3 = primes[n2];
        int n4 = 0;
        while (n > 1) {
            int n5 = n / n3;
            int n6 = n5 * n3;
            if (n6 == n) {
                n = n5;
                ++n4;
                continue;
            }
            arrayList.add(n4);
            n4 = 0;
            n3 = primes[++n2];
        }
        if (n4 > 0) {
            arrayList.add(n4);
        }
        return PrimeFactors.primeListToArray(arrayList);
    }

    public static int getPrime(int n) {
        return primes[n];
    }

    public static int getPrimeCount() {
        return primes.length;
    }

    public JustRatio getJustRatio() {
        long l = 1L;
        long l2 = 1L;
        for (int i = 0; i < this.factors.length; ++i) {
            int n;
            int n2 = this.factors[i];
            int n3 = primes[i];
            if (n2 > 0) {
                for (n = 0; n < n2; ++n) {
                    l *= (long)n3;
                }
                continue;
            }
            if (n2 >= 0) continue;
            n2 = 0 - n2;
            for (n = 0; n < n2; ++n) {
                l2 *= (long)n3;
            }
        }
        return new JustRatio(l, l2);
    }

    public int[] getFactors() {
        return (int[])this.factors.clone();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        this.printFactors(stringBuffer, 1);
        stringBuffer.append("/");
        this.printFactors(stringBuffer, -1);
        return stringBuffer.toString();
    }

    private void printFactors(StringBuffer stringBuffer, int n) {
        boolean bl = false;
        for (int i = 0; i < this.factors.length; ++i) {
            int n2 = this.factors[i] * n;
            if (n2 <= 0) continue;
            if (bl) {
                stringBuffer.append('*');
            }
            int n3 = primes[i];
            if (n2 == 1) {
                stringBuffer.append("" + n3);
            } else if (n2 == 2) {
                stringBuffer.append(n3 + "*" + n3);
            } else if (n2 > 2) {
                stringBuffer.append("(" + n3 + "^" + n2 + ")");
            }
            bl = true;
        }
        if (!bl) {
            stringBuffer.append("1");
        }
    }

    static {
        boolean[] blArray = new boolean[1000];
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 2; i < 500; ++i) {
            if (blArray[i]) continue;
            arrayList.add(i);
            for (int j = 2 * i; j < 1000; j += i) {
                blArray[j] = true;
            }
        }
        primes = PrimeFactors.primeListToArray(arrayList);
    }
}

