/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.view11x;

import com.softsynth.jsyn.util.HarmonicTable;
import com.softsynth.jsyn.view11x.HarmonicFader;
import com.softsynth.jsyn.view11x.WaveDisplay;
import java.awt.Button;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class WaveMaker
extends Panel {
    HarmonicTable table;
    HarmonicFader[] faders;
    int numSamples;
    int numPartials;
    public short[] data;
    Button sawButton;
    Button squareButton;
    Button triButton;
    Button clearButton;
    double minVal = 0.0;
    double maxVal = 0.0;
    WaveDisplay display;

    public WaveMaker(HarmonicTable harmonicTable, WaveDisplay waveDisplay) {
        this.table = harmonicTable;
        this.display = waveDisplay;
        this.numSamples = harmonicTable.length();
        this.numPartials = harmonicTable.getNumPartials();
        this.data = new short[this.numSamples];
        this.faders = new HarmonicFader[this.numPartials];
        this.setLayout(new GridLayout(1, 0));
        for (int i = 0; i < this.numPartials; ++i) {
            this.faders[i] = new HarmonicFader(this, i);
            this.add(this.faders[i]);
        }
        this.sawButton = new Button("Saw");
        this.add(this.sawButton);
        this.sawButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WaveMaker.this.handleSawtoothButton();
            }
        });
        this.squareButton = new Button("Sqr");
        this.add(this.squareButton);
        this.squareButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WaveMaker.this.handleSquareButton();
            }
        });
        this.triButton = new Button("Tri");
        this.add(this.triButton);
        this.triButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WaveMaker.this.handleTriButton();
            }
        });
        this.clearButton = new Button("Clr");
        this.add(this.clearButton);
        this.clearButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WaveMaker.this.handleClearButton();
            }
        });
        harmonicTable.clear();
        this.updateFaders();
    }

    void handleSawtoothButton() {
        this.table.sawtooth();
        this.updateFaders();
        this.display.repaint();
    }

    void handleSquareButton() {
        this.table.square();
        this.updateFaders();
        this.display.repaint();
    }

    void handleTriButton() {
        this.table.triangle();
        this.updateFaders();
        this.display.repaint();
    }

    void handleClearButton() {
        this.table.clear();
        this.updateFaders();
        this.display.repaint();
    }

    void setPartial(int n, double d) {
        this.table.setPartial(n, d);
        this.table.build();
        this.display.repaint();
    }

    void updateFaders() {
        for (int i = 0; i < this.numPartials; ++i) {
            this.faders[i].setValue(this.table.getPartial(i));
        }
    }
}

