/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.view102;

import com.softsynth.jsyn.util.HarmonicTable;
import com.softsynth.jsyn.view102.HarmonicFader;
import com.softsynth.jsyn.view102.WaveDisplay;
import java.awt.Button;
import java.awt.Event;
import java.awt.GridLayout;
import java.awt.Panel;

public class WaveMaker
extends Panel {
    HarmonicTable table;
    HarmonicFader[] faders;
    int numSamples;
    int numPartials;
    public short[] data;
    Button sawButton;
    Button squareButton;
    Button triButton;
    Button clearButton;
    double minVal = 0.0;
    double maxVal = 0.0;
    WaveDisplay display;

    public WaveMaker(HarmonicTable harmonicTable, WaveDisplay waveDisplay) {
        this.table = harmonicTable;
        this.display = waveDisplay;
        this.numSamples = harmonicTable.length();
        this.numPartials = harmonicTable.getNumPartials();
        this.data = new short[this.numSamples];
        this.faders = new HarmonicFader[this.numPartials];
        this.setLayout(new GridLayout(1, 0));
        for (int i = 0; i < this.numPartials; ++i) {
            this.faders[i] = new HarmonicFader(this, i);
            this.add(this.faders[i]);
        }
        this.sawButton = new Button("Saw");
        this.add(this.sawButton);
        this.squareButton = new Button("Sqr");
        this.add(this.squareButton);
        this.triButton = new Button("Tri");
        this.add(this.triButton);
        this.clearButton = new Button("Clr");
        this.add(this.clearButton);
        harmonicTable.clear();
        this.updateFaders();
    }

    void setPartial(int n, double d) {
        this.table.setPartial(n, d);
        this.table.build();
        this.display.repaint();
    }

    void updateFaders() {
        for (int i = 0; i < this.numPartials; ++i) {
            this.faders[i].setValue(this.table.getPartial(i));
        }
    }

    public boolean action(Event event, Object object) {
        if (event.target == this.sawButton) {
            this.table.sawtooth();
            this.updateFaders();
            this.display.repaint();
            return true;
        }
        if (event.target == this.squareButton) {
            this.table.square();
            this.updateFaders();
            this.display.repaint();
            return true;
        }
        if (event.target == this.triButton) {
            this.table.triangle();
            this.updateFaders();
            this.display.repaint();
            return true;
        }
        if (event.target == this.clearButton) {
            this.table.clear();
            this.updateFaders();
            this.display.repaint();
            return true;
        }
        return false;
    }
}

