/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.view102;

import com.softsynth.jsyn.view102.XYController;
import java.awt.Color;
import java.awt.Graphics;

public class InternalBarGraphEditor
extends XYController {
    double[] data;
    int numValues;
    int previousHighlightIndex = -1;

    public InternalBarGraphEditor(double[] dArray) {
        this.setArray(dArray);
    }

    public void setArray(double[] dArray) {
        this.data = dArray;
        this.numValues = dArray.length;
        this.setMaxWorldX(this.numValues);
    }

    void drawHighlight(Graphics graphics, int n) {
        int n2 = this.bounds().width;
        int n3 = this.bounds().height;
        int n4 = n2 / this.numValues;
        int n5 = this.convertWXtoGX(n);
        graphics.setXORMode(Color.orange);
        graphics.fillRect(n5, 0, n4, n3);
        graphics.setPaintMode();
    }

    public void highlight(int n) {
        Graphics graphics = this.getGraphics();
        if (graphics == null) {
            return;
        }
        if (this.previousHighlightIndex >= 0) {
            this.drawHighlight(graphics, this.previousHighlightIndex);
        }
        this.drawHighlight(graphics, n);
        this.previousHighlightIndex = n;
    }

    void updateDrawing(int n, double d, double d2) {
        int n2;
        int n3;
        int n4;
        Graphics graphics = this.getGraphics();
        if (graphics == null) {
            return;
        }
        int n5 = this.bounds().width;
        int n6 = n5 / this.numValues - 4;
        if (n6 < 3) {
            n6 = 3;
        }
        if ((n4 = this.convertWYtoGY(d)) > (n3 = this.convertWYtoGY(d2))) {
            n2 = n4;
            n4 = n3;
            n3 = n2;
        }
        if (n4 != n3) {
            n2 = this.convertWXtoGX(n) + 2;
            graphics.setXORMode(this.getBackground());
            graphics.fillRect(n2, n4, n6, n3 - n4);
            graphics.setPaintMode();
        }
    }

    protected void convertMouse(boolean bl, int n, int n2) {
        int n3 = (int)this.convertGXtoWX(n);
        if (n3 < 0) {
            n3 = 0;
        } else if (n3 >= this.numValues) {
            n3 = this.numValues - 1;
        }
        double d = bl ? this.minWorldY + Math.random() * (this.maxWorldY - this.minWorldY) : this.clipWorldY(this.convertGYtoWY(n2));
        double d2 = this.data[n3];
        this.data[n3] = d;
        if (d2 != d) {
            this.updateDrawing(n3, d2, d);
        }
    }

    public void paint(Graphics graphics) {
        int n = this.bounds().width;
        int n2 = this.bounds().height;
        int n3 = n / this.numValues - 4;
        if (n3 < 3) {
            n3 = 3;
        }
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, n, n2);
        graphics.setColor(this.getForeground());
        for (int i = 0; i < this.numValues; ++i) {
            int n4 = this.convertWXtoGX(i) + 2;
            int n5 = this.convertWYtoGY(this.data[i]);
            graphics.fillRect(n4, n5, n3, n2 - n5);
        }
        this.previousHighlightIndex = -1;
    }
}

