/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.view;

import com.softsynth.jsyn.util.HarmonicTable;
import com.softsynth.jsyn.view.HarmonicFader;
import com.softsynth.jsyn.view.WaveDisplay;
import java.awt.Button;
import java.awt.Event;
import java.awt.GridLayout;
import java.awt.Panel;

public class WaveMaker
extends Panel {
    HarmonicTable table;
    HarmonicFader[] faders;
    int numSamples;
    int numPartials;
    public short[] data;
    Button buildButton;
    Button sawButton;
    Button squareButton;
    Button clearButton;
    double minVal = 0.0;
    double maxVal = 0.0;
    WaveDisplay display;

    public WaveMaker(HarmonicTable harmonicTable, WaveDisplay waveDisplay) {
        this.table = harmonicTable;
        this.display = waveDisplay;
        this.numSamples = harmonicTable.length();
        this.numPartials = harmonicTable.getNumPartials();
        this.data = new short[this.numSamples];
        this.faders = new HarmonicFader[this.numPartials];
        this.setLayout(new GridLayout(1, 0));
        for (int i = 0; i < this.numPartials; ++i) {
            this.faders[i] = new HarmonicFader(harmonicTable, i);
            this.add(this.faders[i]);
        }
        this.buildButton = new Button("Build");
        this.add(this.buildButton);
        this.sawButton = new Button("Saw");
        this.add(this.sawButton);
        this.squareButton = new Button("Square");
        this.add(this.squareButton);
        this.clearButton = new Button("Clear");
        this.add(this.clearButton);
        harmonicTable.clear();
        this.updateFaders();
    }

    void updateFaders() {
        for (int i = 0; i < this.numPartials; ++i) {
            this.faders[i].setValue(this.table.getPartial(i));
        }
    }

    public boolean action(Event event, Object object) {
        if (event.target == this.buildButton) {
            this.table.build();
            this.display.repaint();
            return true;
        }
        if (event.target == this.sawButton) {
            this.table.sawtooth();
            this.updateFaders();
            this.display.repaint();
            return true;
        }
        if (event.target == this.squareButton) {
            this.table.square();
            this.updateFaders();
            this.display.repaint();
            return true;
        }
        if (event.target == this.clearButton) {
            this.table.clear();
            this.updateFaders();
            this.display.repaint();
            return true;
        }
        return false;
    }
}

