/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.view;

import com.softsynth.jsyn.view.WaveTrace;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;
import java.util.Vector;

public class WaveDisplay
extends Canvas {
    Vector traces = new Vector();
    int leftIndex = 0;
    int rightIndex = 512;
    int maxIndex;

    void calcMaxIndex() {
        this.maxIndex = 0;
        for (int i = 0; i < this.traces.size(); ++i) {
            WaveTrace waveTrace = (WaveTrace)this.traces.elementAt(i);
            short[] sArray = waveTrace.data;
            if (sArray.length - 1 <= this.maxIndex) continue;
            this.maxIndex = sArray.length - 1;
        }
    }

    public void setLeftIndex(int n) {
        this.leftIndex = n < 0 ? 0 : n;
    }

    public void setRightIndex(int n) {
        this.rightIndex = n > this.maxIndex ? this.maxIndex : n;
    }

    public void panLeft() {
        int n = (this.rightIndex - this.leftIndex) / 2;
        if (this.leftIndex - n < 0) {
            n = this.leftIndex;
        }
        this.leftIndex -= n;
        this.rightIndex -= n;
    }

    public void panRight() {
        int n = (this.rightIndex - this.leftIndex) / 2;
        if (this.rightIndex + n > this.maxIndex) {
            n = this.maxIndex - this.rightIndex;
        }
        this.leftIndex += n;
        this.rightIndex += n;
    }

    public void zoomIn() {
        int n = (this.rightIndex - this.leftIndex) / 4;
        this.leftIndex += n;
        this.rightIndex -= n;
    }

    void clipIndices() {
        if (this.leftIndex < 0) {
            this.leftIndex = 0;
        }
        if (this.rightIndex > this.maxIndex) {
            this.rightIndex = this.maxIndex;
        }
    }

    public void zoomOut() {
        int n = (this.rightIndex - this.leftIndex) / 2;
        this.leftIndex -= n;
        this.rightIndex += n;
        this.clipIndices();
    }

    public void addTrace(WaveTrace waveTrace) {
        this.traces.addElement(waveTrace);
        this.calcMaxIndex();
    }

    public void removeTrace(WaveTrace waveTrace) {
        this.traces.removeElement(waveTrace);
        this.calcMaxIndex();
    }

    private int shortToY(short s, int n, double d) {
        return n * (32768 - (int)(d * (double)s)) >> 16;
    }

    public void paint(Graphics graphics) {
        int n = this.size().width;
        int n2 = this.size().height;
        graphics.setColor(Color.white);
        graphics.drawLine(0, n2 / 2, n, n2 / 2);
        for (int i = 0; i < this.traces.size(); ++i) {
            WaveTrace waveTrace = (WaveTrace)this.traces.elementAt(i);
            double d = waveTrace.scaleFactor;
            graphics.setColor(waveTrace.color);
            short[] sArray = waveTrace.data;
            if (sArray.length - 1 <= this.leftIndex) continue;
            int n3 = 0;
            int n4 = this.shortToY(sArray[this.leftIndex], n2, d);
            int n5 = sArray.length - 1 < this.rightIndex ? sArray.length - 1 : this.rightIndex;
            for (int j = this.leftIndex + 1; j <= n5; ++j) {
                int n6 = (j - this.leftIndex) * n / (n5 - this.leftIndex);
                int n7 = this.shortToY(sArray[j], n2, d);
                graphics.drawLine(n3, n4, n6, n7);
                n3 = n6;
                n4 = n7;
            }
        }
        graphics.setColor(Color.white);
        graphics.drawString(Integer.toString(this.leftIndex), 5, n2 - 20);
        graphics.drawString(Integer.toString(this.rightIndex), n - 40, n2 - 20);
    }
}

