/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.view;

import com.softsynth.jsyn.SynthAlert;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthPort;
import com.softsynth.jsyn.SynthSound;
import com.softsynth.jsyn.SynthVariable;
import com.softsynth.jsyn.view.PortFader;
import com.softsynth.jsyn.view.UsageDisplay;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.Event;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;

public class SoundTester
extends Panel {
    Checkbox[] cbox;
    SynthSound sound;
    Button hitButton;
    static final int NUM_STAGES = 8;

    public SoundTester(SynthSound synthSound) throws SynthException {
        this.sound = synthSound;
        this.setLayout(new GridLayout(0, 1));
        int n = synthSound.getNumPorts();
        for (int i = 0; i < n; ++i) {
            SynthPort synthPort = synthSound.getPortAt(i);
            if (!(synthPort instanceof SynthVariable)) continue;
            this.addInput((SynthVariable)synthPort);
        }
        Panel panel = new Panel();
        CheckboxGroup checkboxGroup = new CheckboxGroup();
        this.cbox = new Checkbox[8];
        panel.add(new Label("Stage:"));
        for (int i = 0; i < 8; ++i) {
            this.cbox[i] = new Checkbox(Integer.toString(i), checkboxGroup, i == 0);
            panel.add(this.cbox[i]);
        }
        this.add(panel);
        this.hitButton = new Button("Hit");
        this.add(this.hitButton);
        this.add(new UsageDisplay());
    }

    void addInput(SynthVariable synthVariable) throws SynthException {
        this.add(new PortFader(synthVariable, synthVariable.get(), synthVariable.getMin(), synthVariable.getMax()));
    }

    public boolean action(Event event, Object object) {
        try {
            for (int i = 0; i < 8; ++i) {
                if (this.cbox[i] != event.target) continue;
                this.sound.setStage(i);
                return true;
            }
            if (event.target == this.hitButton) {
                this.sound.setStage(0);
                return true;
            }
        }
        catch (SynthException synthException) {
            SynthAlert.showError((Component)this, synthException);
            return true;
        }
        return false;
    }
}

