/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.util;

import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthCircuit;
import com.softsynth.jsyn.SynthContext;
import com.softsynth.jsyn.SynthException;

public abstract class VoiceAllocator {
    static final int LONGTIME = 0x3FFFFFFF;
    SynthCircuit[] voices;
    int[] priorities;
    int[] stopTimes;
    int maxVoices;
    int numVoices = 0;
    SynthContext synthContext;

    public VoiceAllocator(SynthContext synthContext, int n) {
        this.maxVoices = n;
        this.synthContext = synthContext;
        this.voices = new SynthCircuit[n];
        this.priorities = new int[n];
        this.stopTimes = new int[n];
    }

    public VoiceAllocator(int n) {
        this(Synth.getSharedContext(), n);
    }

    public int getMaxVoices() {
        return this.maxVoices;
    }

    public int getNumVoices() {
        return this.numVoices;
    }

    public SynthCircuit getNthVoice(int n) {
        return this.voices[n];
    }

    public abstract SynthCircuit makeVoice() throws SynthException;

    synchronized SynthCircuit addVoice(int n, int n2) throws SynthException {
        SynthCircuit synthCircuit;
        if (this.numVoices == this.maxVoices) {
            return null;
        }
        this.voices[this.numVoices] = synthCircuit = this.makeVoice();
        this.mark(this.numVoices, n, n2);
        ++this.numVoices;
        return synthCircuit;
    }

    synchronized int searchEarliest(int n, int n2) {
        int n3 = Integer.MAX_VALUE;
        int n4 = -1;
        for (int i = 0; i < this.numVoices; ++i) {
            int n5 = this.stopTimes[i] - n;
            if (n2 < this.priorities[i] && n5 > 0 || n5 >= n3) continue;
            n3 = n5;
            n4 = i;
        }
        return n4;
    }

    void mark(int n, int n2, int n3) {
        this.stopTimes[n] = n2;
        this.priorities[n] = n3;
    }

    public synchronized SynthCircuit allocate(int n, int n2, int n3) throws SynthException {
        if (this.numVoices == 0) {
            return this.addVoice(n2, n3);
        }
        int n4 = this.searchEarliest(n, n3 - 1);
        if (n4 >= 0) {
            this.mark(n4, n2, n3);
            return this.voices[n4];
        }
        if (this.numVoices < this.maxVoices) {
            return this.addVoice(n2, n3);
        }
        return null;
    }

    public synchronized SynthCircuit allocate(int n, int n2) throws SynthException {
        return this.allocate(n, n2, 0);
    }

    public synchronized SynthCircuit allocate(int n) throws SynthException {
        return this.allocate(n, n + 0x3FFFFFFF, 0);
    }

    public synchronized SynthCircuit allocate() throws SynthException {
        return this.allocate(this.synthContext.getTickCount());
    }

    public synchronized SynthCircuit steal(int n, int n2, int n3) throws SynthException {
        SynthCircuit synthCircuit = this.allocate(n, n2, n3);
        if (synthCircuit != null) {
            return synthCircuit;
        }
        int n4 = this.searchEarliest(n, n3);
        if (n4 >= 0) {
            if (Synth.verbosity >= 1) {
                System.out.println("VoiceAllocator: steal " + n4);
            }
            this.mark(n4, n2, n3);
            return this.voices[n4];
        }
        return null;
    }

    public synchronized SynthCircuit steal(int n, int n2) throws SynthException {
        return this.steal(n, n2, 0);
    }

    public synchronized SynthCircuit steal(int n) throws SynthException {
        return this.steal(n, n + 0x3FFFFFFF, 0);
    }

    public SynthCircuit steal() throws SynthException {
        return this.steal(this.synthContext.getTickCount());
    }

    public synchronized void free(int n, SynthCircuit synthCircuit) {
        for (int i = 0; i < this.numVoices; ++i) {
            if (synthCircuit != this.voices[i]) continue;
            this.mark(i, n, 0);
            break;
        }
    }

    public void free(SynthCircuit synthCircuit) throws SynthException {
        this.free(this.synthContext.getTickCount(), synthCircuit);
    }

    public void stop(int n) {
        for (int i = 0; i < this.numVoices; ++i) {
            this.voices[i].stop(n);
        }
    }

    public void stop() {
        this.stop(Synth.getTickCount());
    }

    public void delete() {
        this.clear();
    }

    public void clear() {
        for (int i = 0; i < this.numVoices; ++i) {
            this.voices[i].delete();
            this.voices[i] = null;
        }
        this.numVoices = 0;
    }
}

