/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.util;

import com.softsynth.jsyn.SampleWriter;
import com.softsynth.jsyn.SampleWriter_16F1;
import com.softsynth.jsyn.SampleWriter_16F2;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthContext;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthInput;
import com.softsynth.jsyn.util.SampleQueueInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class StreamRecorder
extends FilterOutputStream
implements Runnable {
    public SynthInput input;
    SynthContext synthContext;
    SampleWriter sampler;
    SampleQueueInputStream audioStream;
    boolean isLittleEndian = true;
    byte[] buffer;
    short[] samples;
    Thread thread;
    boolean go = false;
    boolean done = false;
    int channelsPerFrame = 1;
    int framesPerBuffer;

    public StreamRecorder(OutputStream outputStream, int n, int n2, int n3) {
        this(Synth.getSharedContext(), outputStream, n, n2, n3);
    }

    public StreamRecorder(SynthContext synthContext, OutputStream outputStream, int n, int n2, int n3) {
        super(outputStream);
        this.synthContext = synthContext;
        if (n3 == 1) {
            this.sampler = new SampleWriter_16F1(synthContext);
        } else if (n3 == 2) {
            this.sampler = new SampleWriter_16F2(synthContext);
        } else {
            throw new RuntimeException("channelsPerFrame must be 1 or 2");
        }
        this.input = this.sampler.input;
        if (n2 < 2) {
            n2 = 2;
        }
        this.audioStream = new SampleQueueInputStream(this.sampler.samplePort, n * n2, n3);
        int n4 = n * n3 * 2;
        this.buffer = new byte[n4];
        this.samples = new short[n4 / 2];
        this.channelsPerFrame = n3;
        this.framesPerBuffer = n;
    }

    public void setLittleEndianness(boolean bl) {
        this.isLittleEndian = bl;
    }

    public boolean getLittleEndianness() {
        return this.isLittleEndian;
    }

    public boolean isLittleEndian() {
        return this.isLittleEndian;
    }

    public void transfer() throws IOException {
        this.audioStream.read(this.samples, 0, this.framesPerBuffer);
        int n = 0;
        if (this.isLittleEndian) {
            for (int i = 0; i < this.samples.length; ++i) {
                this.buffer[n++] = (byte)this.samples[i];
                this.buffer[n++] = (byte)(this.samples[i] >> 8);
            }
        } else {
            for (int i = 0; i < this.samples.length; ++i) {
                this.buffer[n++] = (byte)(this.samples[i] >> 8);
                this.buffer[n++] = (byte)this.samples[i];
            }
        }
        this.write(this.buffer);
    }

    public void run() {
        try {
            while (this.go) {
                this.transfer();
            }
            this.flush();
        }
        catch (IOException iOException) {
            System.out.println("StreamRecorder.run() caught " + iOException);
            iOException.printStackTrace();
        }
        catch (SynthException synthException) {
            System.out.println("StreamRecorder.run() caught " + synthException);
        }
        this.done = true;
    }

    public void start(int n) {
        if (this.thread != null) {
            this.stop(n);
        }
        this.audioStream.start(n);
        this.sampler.start(n);
        this.thread = new Thread(this);
        this.go = true;
        this.done = false;
        this.thread.start();
    }

    public void stop(int n) {
        int n2 = 32;
        int n3 = (int)(this.synthContext.getTickRate() * 5.0 / (double)n2);
        this.go = false;
        this.thread.interrupt();
        while (!this.done && n3-- > 0) {
            this.synthContext.sleepForTicks(n2);
        }
        if (n3 <= 0) {
            System.out.println("StreamRecorder.stop() - timeout = " + n3);
        }
        this.audioStream.stop(n);
        this.sampler.stop(n);
        this.thread = null;
    }
}

