/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.util;

import com.softsynth.jsyn.SynthContext;
import com.softsynth.jsyn.SynthSample;
import com.softsynth.jsyn.SynthSampleQueue;

public abstract class SampleQueueStream {
    SynthSampleQueue queue;
    SynthSample sample;
    int frameCount = 0;
    int frameIndex = 0;
    private int lastFramesBackground = 0;
    int startTime;
    boolean running = false;
    boolean flowError = false;
    int maxTicksPerSleep;
    SynthContext synthContext = null;

    public SampleQueueStream(SynthSampleQueue synthSampleQueue, int n, int n2) {
        this.queue = synthSampleQueue;
        this.synthContext = synthSampleQueue.getSound().getSynthContext();
        this.lastFramesBackground = synthSampleQueue.getNumFramesMoved();
        this.sample = new SynthSample(this.synthContext, n, n2);
        int n3 = n / (2 * this.synthContext.getFramesPerTick());
        this.maxTicksPerSleep = n3 / 8;
        if (this.maxTicksPerSleep < 1) {
            this.maxTicksPerSleep = 1;
        }
        if (this.maxTicksPerSleep < 64) {
            this.maxTicksPerSleep = n3 / 4;
        }
        if (this.maxTicksPerSleep < 64) {
            this.maxTicksPerSleep = n3 / 2;
        }
    }

    public SynthSample getSample() {
        return this.sample;
    }

    public void start(int n) {
        this.startTime = n;
        this.running = true;
        this.flowError = false;
    }

    public void stop(int n) {
        this.running = false;
        this.frameCount = 0;
    }

    public synchronized int available() {
        int n = this.queue.getNumFramesMoved();
        int n2 = n - this.lastFramesBackground;
        this.lastFramesBackground = n;
        this.frameCount -= n2;
        int n3 = this.calcAvailable(this.frameCount);
        if (n3 < 0) {
            n3 = 0;
        } else if (n3 > this.sample.getNumFrames()) {
            this.flowError = true;
            n3 = this.sample.getNumFrames();
        }
        return n3;
    }

    public int move(short[] sArray, int n, int n2) {
        int n3 = n2;
        while (n3 > 0) {
            int n4;
            int n5 = this.available();
            if (n5 > 0) {
                n4 = n3 > n5 ? n5 : n3;
                this.frameCount += this.moveNow(sArray, n, n4);
                n += n4 * this.sample.getChannelsPerFrame();
                n3 -= n4;
            }
            if (n3 <= 0) continue;
            if (!this.running) {
                return n2 - n3;
            }
            n4 = n3 / this.synthContext.getFramesPerTick();
            if (n4 > this.maxTicksPerSleep) {
                n4 = this.maxTicksPerSleep;
            } else if (n4 < 1) {
                n4 = 1;
            }
            this.synthContext.sleepForTicks(n4);
        }
        return n2;
    }

    synchronized int moveNow(short[] sArray, int n, int n2) {
        if (this.frameIndex + n2 <= this.sample.getNumFrames()) {
            this.moveDirect(this.frameIndex, sArray, n, n2);
            this.queue.queue(this.sample, this.frameIndex, n2);
            this.frameIndex += n2;
            if (this.frameIndex >= this.sample.getNumFrames()) {
                this.frameIndex -= this.sample.getNumFrames();
            }
        } else {
            int n3 = this.sample.getNumFrames() - this.frameIndex;
            this.moveDirect(this.frameIndex, sArray, n, n3);
            this.queue.queue(this.sample, this.frameIndex, n3);
            int n4 = n2 - n3;
            this.moveDirect(0, sArray, n += n3 * this.sample.getChannelsPerFrame(), n4);
            this.queue.queue(this.sample, 0, n4);
            this.frameIndex = n4;
        }
        return n2;
    }

    synchronized boolean checkAndClearFlowError() {
        boolean bl = this.flowError;
        this.flowError = false;
        return bl;
    }

    abstract void moveDirect(int var1, short[] var2, int var3, int var4);

    abstract int calcAvailable(int var1);
}

