/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.util;

import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthTable;

public class HarmonicTable
extends SynthTable {
    public short[] data;
    double[] partials;
    double[] samples;
    int numPartials;
    int numSamples;
    double minVal = 0.0;
    double maxVal = 0.0;

    public HarmonicTable(int n, int n2) throws SynthException {
        super(n);
        this.partials = new double[n2];
        this.samples = new double[n];
        this.data = new short[n];
        this.numSamples = n;
        this.numPartials = n2;
        this.clear();
    }

    public void setPartial(int n, double d) {
        this.partials[n] = d;
    }

    public double getPartial(int n) {
        return this.partials[n];
    }

    public int getNumPartials() {
        return this.numPartials;
    }

    void addHarmonics() {
        for (int i = 0; i < this.numSamples - 1; ++i) {
            double d = 0.0;
            for (int j = 0; j < this.numPartials; ++j) {
                double d2 = Math.sin((double)(j + 1) * (Math.PI * 2 * (double)i / (double)(this.numSamples - 1)));
                d += this.partials[j] * d2;
            }
            this.samples[i] = d;
        }
        this.samples[this.numSamples - 1] = this.samples[0];
    }

    void findMinMax() {
        this.minVal = Double.MAX_VALUE;
        this.maxVal = Double.MIN_VALUE;
        for (int i = 0; i < this.numSamples; ++i) {
            double d = this.samples[i];
            if (d < this.minVal) {
                this.minVal = d;
            }
            if (!(d > this.maxVal)) continue;
            this.maxVal = d;
        }
    }

    void scale(double d) {
        int n = 0;
        while (n < this.numSamples) {
            int n2 = n++;
            this.samples[n2] = this.samples[n2] * d;
        }
    }

    void normalize() {
        this.findMinMax();
        double d = Math.max(Math.abs(this.minVal), Math.abs(this.maxVal));
        if (d < 0.001) {
            d = 0.001;
        }
        double d2 = 1.0 / d;
        this.scale(d2);
    }

    public void build() {
        this.addHarmonics();
        this.normalize();
        this.write(this.samples);
        for (int i = 0; i < this.numSamples; ++i) {
            this.data[i] = (short)(32767.0 * this.samples[i]);
        }
    }

    public void square() {
        for (int i = 0; i < this.numPartials; ++i) {
            double d = (i & 1) == 1 ? 0.0 : 2.0 / (Math.PI * (double)(i + 1));
            this.partials[i] = d;
        }
        this.build();
    }

    public void triangle() {
        for (int i = 0; i < this.numPartials; ++i) {
            double d = (i & 1) == 1 ? 0.0 : 1.0 / (double)((i + 1) * (i + 1));
            this.partials[i] = d;
        }
        this.build();
    }

    public void sawtooth() {
        for (int i = 0; i < this.numPartials; ++i) {
            double d = 1.0 / (double)(i + 1);
            if ((i & 1) == 1) {
                d = -d;
            }
            this.partials[i] = d;
        }
        this.build();
    }

    public void clear() {
        for (int i = 0; i < this.numPartials; ++i) {
            this.partials[i] = 0.0;
        }
        this.build();
    }
}

