/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.util;

import com.softsynth.jsyn.BusReader;
import com.softsynth.jsyn.BusWriter;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthCircuit;
import com.softsynth.jsyn.SynthContext;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthOutput;
import com.softsynth.jsyn.util.VoiceAllocator;
import java.util.Vector;

public abstract class BussedVoiceAllocator
extends VoiceAllocator {
    BusReader busReader;
    Vector writers = new Vector();
    public SynthOutput output;

    public BussedVoiceAllocator(SynthContext synthContext, int n) {
        super(synthContext, n);
        this.busReader = new BusReader(synthContext);
        this.output = this.busReader.output;
        this.busReader.setPriority(0);
        this.busReader.start();
    }

    public BussedVoiceAllocator(int n) {
        this(Synth.getSharedContext(), n);
    }

    public synchronized SynthCircuit addVoiceToMix(SynthCircuit synthCircuit) throws SynthException {
        BusWriter busWriter = new BusWriter();
        this.writers.addElement(busWriter);
        synthCircuit.output.connect(busWriter.input);
        busWriter.busOutput.connect(this.busReader.busInput);
        busWriter.start();
        return synthCircuit;
    }

    public SynthOutput getOutput() {
        return this.busReader.output;
    }

    public synchronized void delete() {
        super.delete();
        this.busReader.delete();
        this.output = null;
    }

    public synchronized void clear() {
        super.clear();
        while (!this.writers.isEmpty()) {
            BusWriter busWriter = (BusWriter)this.writers.lastElement();
            this.writers.removeElement(busWriter);
            busWriter.delete();
        }
    }
}

