/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.circuits;

import com.softsynth.jsyn.AddUnit;
import com.softsynth.jsyn.DivideUnit;
import com.softsynth.jsyn.Filter_1o1z;
import com.softsynth.jsyn.InterpolatingDelayUnit;
import com.softsynth.jsyn.MultiplyAddUnit;
import com.softsynth.jsyn.SampleReader_16V1;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthInput;
import com.softsynth.jsyn.SynthNote;
import com.softsynth.jsyn.circuits.PluckSample;

public class TunedPluckedString
extends SynthNote {
    private SampleReader_16V1 myPluckPlayer = new SampleReader_16V1();
    private InterpolatingDelayUnit myDelay;
    private Filter_1o1z myAverager;
    private MultiplyAddUnit myFeedback;
    private DivideUnit myDivider;
    private AddUnit adjuster;
    public SynthInput rate;
    public SynthInput pluckStrength;
    public SynthInput feedback;
    private PluckSample myPluckSample;
    static final int PLUCK_SIZE = 300;

    public TunedPluckedString() throws SynthException {
        this(0.01);
    }

    public TunedPluckedString(double d) throws SynthException {
        this.add(this.myPluckPlayer);
        this.myDivider = new DivideUnit();
        this.add(this.myDivider);
        this.adjuster = new AddUnit();
        this.add(this.adjuster);
        this.myDelay = new InterpolatingDelayUnit(d);
        this.add(this.myDelay);
        this.myAverager = new Filter_1o1z();
        this.add(this.myAverager);
        this.myFeedback = new MultiplyAddUnit();
        this.add(this.myFeedback);
        this.myPluckSample = new PluckSample(300);
        this.myPluckSample.fill();
        this.myDelay.output.connect(this.myAverager.input);
        this.myAverager.output.connect(this.myFeedback.inputA);
        this.myPluckPlayer.output.connect(this.myFeedback.inputC);
        this.myFeedback.output.connect(this.myDelay.input);
        this.myDivider.output.connect(this.adjuster.inputA);
        this.adjuster.output.connect(this.myDelay.delay);
        this.myDivider.inputA.set(1.0);
        this.myDivider.inputB.setMin(30.0);
        this.myDivider.inputB.setMax(5000.0);
        double d2 = Synth.getSharedContext().getFrameRate();
        if (d2 < 10.0) {
            d2 = 44100.0;
        }
        double d3 = -8.5 / d2;
        this.adjuster.inputB.set(d3);
        this.rate = this.myPluckPlayer.rate;
        this.addPort(this.rate);
        this.frequency = this.myDivider.inputB;
        this.addPort(this.frequency, "Frequency");
        this.amplitude = this.pluckStrength = this.myPluckPlayer.amplitude;
        this.addPort(this.pluckStrength, "Amplitude");
        this.feedback = this.myFeedback.inputB;
        this.addPort(this.feedback, "Feedback");
        this.output = this.myFeedback.output;
        this.addPort(this.output);
        this.rate.setup(0.0, 20000.0, 60000.0);
        this.pluckStrength.setup(0.0, 0.5, 1.0);
        this.feedback.setup(-1.0, -0.999, -0.9);
        this.myDelay.delay.setup(0.0, d / 2.0, d);
    }

    public void pluck() throws SynthException {
        this.noteOn(this.getSynthContext().getTickCount(), 440.0, 0.5);
    }

    public void setStage(int n, int n2) throws SynthException {
        switch (n2) {
            case 0: {
                this.myPluckPlayer.samplePort.queue(n, this.myPluckSample);
                break;
            }
        }
    }
}

